/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddQualiferCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddQualiferToMethodParamCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class QualifierAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    private List<SingleVariableDeclaration> params;

    @Override
    protected void setUpFields() {
        this.params = new ArrayList<SingleVariableDeclaration>();
    }

    @Override
    public String getAnnotationName() {
        return "Qualifier";
    }

    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        ITypeBinding typeBinding;
        if (ProposalCalculatorUtil.hasAnnotation("Autowired", (ASTNode)fieldDecl) && !ProposalCalculatorUtil.hasAnnotation("Qualifier", (ASTNode)fieldDecl) && (typeBinding = fieldDecl.getType().resolveBinding()) != null) {
            return ProposalCalculatorUtil.getMatchingBeans(context, typeBinding).size() > 0;
        }
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        if (ProposalCalculatorUtil.hasAnnotation("Autowired", (ASTNode)methodDecl)) {
            List params = methodDecl.parameters();
            for (SingleVariableDeclaration param : params) {
                ITypeBinding typeBinding;
                if (ProposalCalculatorUtil.hasAnnotation(this.getAnnotationName(), (ASTNode)param) || (typeBinding = param.getType().resolveBinding()) == null || ProposalCalculatorUtil.getMatchingBeans(context, typeBinding).size() <= 0) continue;
                this.params.add(param);
            }
        }
        return this.params.size() > 0;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForField(FieldDeclaration fieldDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddQualiferCompletionProposal((BodyDeclaration)fieldDecl, cu));
        return proposals;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddQualiferToMethodParamCompletionProposal(this.params, methodDecl, cu));
        return proposals;
    }
}

