/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelectionHandler;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelector;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ProjectLabel;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ProjectSelectionPart;

public class ProjectSelectorFactory {
    private Shell shell;
    private Composite parent;
    private Collection<IProject> projects;
    private IProjectSelectionHandler handler;

    public ProjectSelectorFactory(Shell shell, Composite parent, Collection<IProject> projects, IProjectSelectionHandler handler) {
        this.shell = shell;
        this.parent = parent;
        this.projects = projects;
        this.handler = handler;
    }

    public IProjectSelector getProjectSelector() {
        if (this.canCreate()) {
            if (this.projects.size() == 1) {
                return new ProjectLabel(this.shell, this.parent, this.projects.iterator().next().getName());
            }
            return new ProjectSelectionPart(this.shell, this.parent, this.projects, this.handler);
        }
        return null;
    }

    protected boolean canCreate() {
        return this.projects != null && !this.projects.isEmpty() && this.shell != null && !this.shell.isDisposed() && this.parent != null;
    }
}

