/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.ide.eclipse.beans.core.DefaultBeanDefinitionRegistry;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfigSet;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.beans.core.namespaces.ToolAnnotationUtils;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidationContext;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.type.asm.CachingClassReaderFactory;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeansValidationContext
extends AbstractValidationContext
implements IBeansValidationContext {
    private static final char KEY_SEPARATOR_CHAR = '/';
    private Map<String, Set<BeanDefinition>> beanLookupCache;
    private ClassReaderFactory classReaderFactory;
    private BeanDefinitionRegistry completeRegistry;
    private BeanDefinitionRegistry incompleteRegistry;
    private IProjectClassLoaderSupport projectClassLoaderSupport;
    private final Map<AttributeDescriptor, List<ToolAnnotationUtils.ToolAnnotationData>> toolAnnotationLookupCache;

    public BeansValidationContext(IBeansConfig config, IResourceModelElement contextElement) {
        super((IResourceModelElement)config, contextElement);
        this.incompleteRegistry = this.createRegistry(config, contextElement, false);
        this.completeRegistry = this.createRegistry(config, contextElement, true);
        this.beanLookupCache = new HashMap<String, Set<BeanDefinition>>();
        this.toolAnnotationLookupCache = new HashMap<AttributeDescriptor, List<ToolAnnotationUtils.ToolAnnotationData>>();
    }

    @Override
    public synchronized ClassReaderFactory getClassReaderFactory() {
        if (this.classReaderFactory == null) {
            this.classReaderFactory = new CachingClassReaderFactory(JdtUtils.getClassLoader((IProject)this.getRootElement().getElementResource().getProject(), null));
        }
        return this.classReaderFactory;
    }

    @Override
    public BeanDefinitionRegistry getCompleteRegistry() {
        return this.completeRegistry;
    }

    @Override
    public BeanDefinitionRegistry getIncompleteRegistry() {
        return this.incompleteRegistry;
    }

    @Override
    public synchronized IProjectClassLoaderSupport getProjectClassLoaderSupport() {
        if (this.projectClassLoaderSupport == null) {
            this.projectClassLoaderSupport = JdtUtils.getProjectClassLoaderSupport((IProject)this.getRootElementProject(), null);
        }
        return this.projectClassLoaderSupport;
    }

    @Override
    public Set<BeanDefinition> getRegisteredBeanDefinition(String beanName, String beanClass) {
        Assert.notNull((Object)beanName);
        Assert.notNull((Object)beanClass);
        String key = String.valueOf(beanClass) + '/' + beanName;
        if (this.beanLookupCache.containsKey(key)) {
            return this.beanLookupCache.get(key);
        }
        Set<BeanDefinition> bds = ValidationRuleUtils.getBeanDefinitions(beanName, beanClass, this);
        this.beanLookupCache.put(key, bds);
        return bds;
    }

    @Override
    public IProject getRootElementProject() {
        return this.getRootElement().getElementResource() != null ? this.getRootElement().getElementResource().getProject() : null;
    }

    @Override
    public IResource getRootElementResource() {
        return this.getRootElement().getElementResource();
    }

    public synchronized List<ToolAnnotationUtils.ToolAnnotationData> getToolAnnotation(Node n, String attributeName) {
        AttributeDescriptor descriptor = AttributeDescriptor.create(n, attributeName);
        if (this.toolAnnotationLookupCache.containsKey(descriptor)) {
            return this.toolAnnotationLookupCache.get(descriptor);
        }
        ArrayList<ToolAnnotationUtils.ToolAnnotationData> annotationDatas = new ArrayList<ToolAnnotationUtils.ToolAnnotationData>();
        List<Element> appInfoElements = ToolAnnotationUtils.getApplicationInformationElements(n, attributeName);
        for (Element elem : appInfoElements) {
            NodeList children = elem.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                ToolAnnotationUtils.ToolAnnotationData annotationData;
                Node annotation = children.item(j);
                if (annotation.getNodeType() == 1 && "annotation".equals(annotation.getLocalName()) && "http://www.springframework.org/schema/tool".equals(annotation.getNamespaceURI()) && (annotationData = ToolAnnotationUtils.getToolAnnotationData(annotation)) != null) {
                    annotationDatas.add(annotationData);
                }
                ++j;
            }
        }
        this.toolAnnotationLookupCache.put(descriptor, annotationDatas);
        return annotationDatas;
    }

    @Override
    public boolean isBeanRegistered(String beanName, String beanClass) {
        Set<BeanDefinition> bds = this.getRegisteredBeanDefinition(beanName, beanClass);
        return bds != null && bds.size() > 0;
    }

    private BeanDefinitionRegistry createRegistry(IBeansConfig config, IResourceModelElement contextElement, boolean fillCompletely) {
        DefaultBeanDefinitionRegistry registry = new DefaultBeanDefinitionRegistry();
        if (contextElement instanceof BeansConfigSet) {
            IBeansConfigSet configSet = (IBeansConfigSet)contextElement;
            if (fillCompletely) {
                registry.setAllowAliasOverriding(true);
                registry.setAllowBeanDefinitionOverriding(true);
            } else {
                registry.setAllowAliasOverriding(configSet.isAllowAliasOverriding());
                registry.setAllowBeanDefinitionOverriding(configSet.isAllowBeanDefinitionOverriding());
            }
            for (IBeansConfig csConfig : configSet.getConfigs()) {
                if (fillCompletely || !config.equals(csConfig)) {
                    BeansModelUtils.register(configSet, csConfig, registry);
                    continue;
                }
                break;
            }
        } else if (contextElement instanceof IBeansConfig && !config.equals(contextElement)) {
            registry.setAllowAliasOverriding(true);
            registry.setAllowBeanDefinitionOverriding(true);
            if (fillCompletely) {
                BeansModelUtils.register(null, (IBeansConfig)contextElement, registry);
            }
        } else {
            registry.setAllowAliasOverriding(false);
            registry.setAllowBeanDefinitionOverriding(false);
            if (fillCompletely) {
                BeansModelUtils.register(null, config, registry);
            }
        }
        return registry;
    }

    protected Set<ValidationProblem> createProblems(IResourceModelElement element, String problemId, int severity, String message, ValidationProblemAttribute ... attributes) {
        Set problems = super.createProblems(element, problemId, severity, message, attributes);
        IResource resource = element.getElementResource();
        if (!resource.equals((Object)this.getRootElementResource())) {
            IBeansImport beansImport = BeansModelUtils.getParentOfClass((IModelElement)element, IBeansImport.class);
            while (beansImport != null) {
                if (severity == 2) {
                    problems.add(this.createProblem((IResourceModelElement)beansImport, "", 2, "Validation error occured in imported configuration file '" + element.getElementResource().getProjectRelativePath().toString() + "'", new ValidationProblemAttribute[0]));
                } else if (severity == 1) {
                    problems.add(this.createProblem((IResourceModelElement)beansImport, "", 1, "Validation warning occured in imported configuration file '" + element.getElementResource().getProjectRelativePath().toString() + "'", new ValidationProblemAttribute[0]));
                }
                beansImport = BeansModelUtils.getParentOfClass(beansImport, IBeansImport.class);
            }
        }
        return problems;
    }

    protected StringBuilder decorateErrorMessage(StringBuilder builder) {
        IResourceModelElement context = this.getContextElement();
        if (context != null && context.getElementResource() != null) {
            String projectName = context.getElementResource().getProject().getName();
            if (context instanceof IBeansConfigSet) {
                builder.append(String.format(" [config set: %s/%s]", projectName, context.getElementName()));
            }
        }
        return builder;
    }

    static class AttributeDescriptor {
        private final String attributeName;
        private final String localName;
        private final String namespaceUri;

        private AttributeDescriptor(String namespaceUri, String localName, String attributeName) {
            this.namespaceUri = namespaceUri;
            this.localName = localName;
            this.attributeName = attributeName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AttributeDescriptor)) {
                return false;
            }
            AttributeDescriptor other = (AttributeDescriptor)obj;
            if (!ObjectUtils.nullSafeEquals((Object)this.namespaceUri, (Object)other.namespaceUri)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.localName, (Object)other.localName)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.attributeName, (Object)this.attributeName);
        }

        public int hashCode() {
            int hashCode = 7;
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.namespaceUri);
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.localName);
            hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.attributeName);
            return hashCode;
        }

        public static AttributeDescriptor create(Node n, String attributeName) {
            return new AttributeDescriptor(n.getNamespaceURI(), n.getLocalName(), attributeName);
        }
    }
}

