/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigEditor;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigSectionPart;
import org.springframework.ide.eclipse.config.ui.editors.Messages;
import org.springframework.ide.eclipse.config.ui.editors.SpringConfigInputAccessor;
import org.springframework.ide.eclipse.config.ui.hyperlinks.AdviceMethodHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.BeanHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.ClassHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.FactoryMethodHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.FieldHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.ImportHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.InitDestroyMethodHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.ListenerMethodHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.LookupReplaceMethodHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.PointcutReferenceHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.PropertyNameHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.hyperlinks.ToolAnnotationBasedHyperlinkProvider;
import org.springframework.ide.eclipse.config.ui.widgets.ButtonAttribute;
import org.springframework.ide.eclipse.config.ui.widgets.ComboAttribute;
import org.springframework.ide.eclipse.config.ui.widgets.HyperlinkedComboAttribute;
import org.springframework.ide.eclipse.config.ui.widgets.HyperlinkedTextAttribute;
import org.springframework.ide.eclipse.config.ui.widgets.TextAreaAttribute;
import org.springframework.ide.eclipse.config.ui.widgets.TextAttribute;
import org.springframework.ide.eclipse.config.ui.wizards.ExtendedNewClassCreationWizard;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

public abstract class AbstractConfigDetailsSectionPart
extends AbstractConfigSectionPart {
    private final FormToolkit toolkit;
    private final SpringConfigInputAccessor delegate;

    public AbstractConfigDetailsSectionPart(AbstractConfigEditor editor, IDOMElement input, Composite parent, FormToolkit toolkit) {
        super(editor, input, parent, toolkit, 384);
        this.toolkit = toolkit;
        this.delegate = new SpringConfigInputAccessor(editor, input);
    }

    protected HyperlinkedTextAttribute createAdviceMethodAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                AdviceMethodHyperlinkProvider provider = new AdviceMethodHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected abstract void createAttributes(Composite var1);

    protected HyperlinkedTextAttribute createBeanAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                BeanHyperlinkProvider provider = new BeanHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected ButtonAttribute createClassAttribute(Composite client, String attr, final boolean includeInterfaces, boolean required) {
        ButtonAttribute buttonAttr = new ButtonAttribute(client, this.toolkit, attr, required){

            @Override
            public void browse() {
                AbstractConfigDetailsSectionPart.this.doOpenTypeDialog(this.attr, this.text.getText(), includeInterfaces);
            }

            @Override
            public void modifyAttribute() {
                AbstractConfigDetailsSectionPart.this.editAttribute(this.attr, this.text.getText());
            }

            @Override
            public void openHyperlink() {
                ClassHyperlinkProvider provider = new ClassHyperlinkProvider((ITextViewer)AbstractConfigDetailsSectionPart.this.getConfigEditor().getTextViewer(), AbstractConfigDetailsSectionPart.this.getInput(), this.attr);
                if (!provider.open(this.text.getText())) {
                    AbstractConfigDetailsSectionPart.this.openNewClassWizard(this.attr, this.text.getText());
                }
            }

            @Override
            public void update() {
                AbstractConfigDetailsSectionPart.this.setTextValue(this.text, AbstractConfigDetailsSectionPart.this.getAttributeValue(this.attr));
            }
        };
        buttonAttr.createAttribute();
        return buttonAttr;
    }

    protected ComboAttribute createComboAttribute(Composite client, String attr, String[] values, boolean required) {
        ComboAttribute comboAttr = new ComboAttribute(client, this.toolkit, attr, values, required){

            @Override
            public void modifyAttribute() {
                AbstractConfigDetailsSectionPart.this.editAttribute(this.attr, this.combo.getItem(this.combo.getSelectionIndex()));
            }

            @Override
            public void update() {
                AbstractConfigDetailsSectionPart.this.setComboSelection(this.combo, AbstractConfigDetailsSectionPart.this.getAttributeValue(this.attr));
            }
        };
        comboAttr.createAttribute(2);
        return comboAttr;
    }

    @Override
    public void createContent() {
        Section detailsSection = this.getSection();
        detailsSection.setLayout((Layout)new GridLayout());
        detailsSection.setLayoutData((Object)new GridData(770));
        detailsSection.setText(Messages.getString("ToolingAwareDetailsPart.DETAILS_SECTION_TITLE"));
        detailsSection.setDescription(Messages.getString("ToolingAwareDetailsPart.DETAILS_SECTION_DESCRIPTION"));
        Composite detailsClient = this.toolkit.createComposite((Composite)detailsSection);
        detailsClient.setLayout((Layout)new GridLayout(3, false));
        detailsClient.setLayoutData((Object)new GridData(768));
        detailsSection.setClient((Control)detailsClient);
        this.createAttributes(detailsClient);
        this.toolkit.paintBordersFor(detailsClient);
    }

    protected HyperlinkedTextAttribute createFactoryMethodAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                FactoryMethodHyperlinkProvider provider = new FactoryMethodHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createFactoryMethodAttribute(Composite client, String attr, final String referenceNode, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                FactoryMethodHyperlinkProvider provider = new FactoryMethodHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr, referenceNode);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createFieldAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                FieldHyperlinkProvider provider = new FieldHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createImportAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                ImportHyperlinkProvider provider = new ImportHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createInitDestroyMethodAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                InitDestroyMethodHyperlinkProvider provider = new InitDestroyMethodHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createListenerMethodAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                ListenerMethodHyperlinkProvider provider = new ListenerMethodHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createLookupReplaceMethodAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                LookupReplaceMethodHyperlinkProvider provider = new LookupReplaceMethodHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createPointcutAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                PointcutReferenceHyperlinkProvider provider = new PointcutReferenceHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected HyperlinkedTextAttribute createPropertyNameAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                PropertyNameHyperlinkProvider provider = new PropertyNameHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    protected TextAreaAttribute createTextArea(Composite client, String elem) {
        TextAreaAttribute textElem = new TextAreaAttribute(client, this.toolkit, elem){

            @Override
            public void modifyAttribute() {
                AbstractConfigDetailsSectionPart.this.editElement(this.text.getText());
            }

            @Override
            public void update() {
                AbstractConfigDetailsSectionPart.this.setTextValue(this.text, AbstractConfigDetailsSectionPart.this.getElementValue());
            }
        };
        textElem.createAttribute(2);
        return textElem;
    }

    protected TextAttribute createTextAttribute(Composite client, String attr, boolean required) {
        TextAttribute textAttr = new TextAttribute(client, this.toolkit, attr, required){

            @Override
            public void modifyAttribute() {
                AbstractConfigDetailsSectionPart.this.editAttribute(this.attr, this.text.getText());
            }

            @Override
            public void update() {
                AbstractConfigDetailsSectionPart.this.setTextValue(this.text, AbstractConfigDetailsSectionPart.this.getAttributeValue(this.attr));
            }
        };
        textAttr.createAttribute(2);
        return textAttr;
    }

    protected HyperlinkedTextAttribute createToolAnnotationAttribute(Composite client, String attr, boolean required) {
        XmlBackedHyperlinkTextAttribute linkAttr = new XmlBackedHyperlinkTextAttribute(this, client, this.toolkit, attr, required){

            @Override
            public void openHyperlink() {
                ToolAnnotationBasedHyperlinkProvider provider = new ToolAnnotationBasedHyperlinkProvider((ITextViewer)this.getConfigEditor().getTextViewer(), this.getInput(), this.attr);
                provider.open(this.text.getText());
            }
        };
        linkAttr.createAttribute(2);
        return linkAttr;
    }

    private void doOpenTypeDialog(String attr, String filter, boolean includeInterfaces) {
        filter = filter.replace('$', '.');
        try {
            if (filter == null) {
                filter = "";
            }
            int scope = includeInterfaces ? 512 : 2;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getConfigEditor().getSite().getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, (int)scope, (boolean)false, (String)filter);
            dialog.setTitle(Messages.getString("AbstractNamespaceDetailsPart.TYPE_SELECTION_DIALOG_TITLE"));
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                String newValue = type.getFullyQualifiedName('$');
                this.editAttribute(attr, newValue);
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.config.ui", Messages.getString("AbstractNamespaceDetailsPart.ERROR_OPENING_DIALOG"), (Throwable)e));
        }
    }

    private void editAttribute(String attrName, String newValue) {
        this.delegate.editAttribute(attrName, newValue);
    }

    private void editElement(String elemValue) {
        this.delegate.editElement(elemValue);
    }

    private String getAttributeValue(String attr) {
        return this.delegate.getAttributeValue(attr);
    }

    private String getElementValue() {
        return this.delegate.getElementValue();
    }

    private void openNewClassWizard(String attr, String name) {
        name = name.replace('$', '.');
        IProject project = this.getConfigEditor().getResourceFile().getProject();
        ExtendedNewClassCreationWizard wizard = new ExtendedNewClassCreationWizard(project, name, true);
        wizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(this.getConfigEditor().getSite().getShell(), (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            String newValue = wizard.getQualifiedName();
            this.editAttribute(attr, newValue);
        }
    }

    protected void setComboSelection(Combo combo, String value) {
        int i = 0;
        while (i < combo.getItemCount()) {
            String item = combo.getItem(i);
            if (item.equals(value) && combo.getSelectionIndex() != i) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    protected void setTextValue(Text text, String value) {
        if (!text.getText().equals(value)) {
            text.setText(value);
            text.setSelection(text.getText().length());
        }
    }

    protected abstract class XmlBackedHyperlinkComboAttribute
    extends HyperlinkedComboAttribute {
        public XmlBackedHyperlinkComboAttribute(Composite client, FormToolkit toolkit, String attrName) {
            this(client, toolkit, attrName, false);
        }

        public XmlBackedHyperlinkComboAttribute(Composite client, FormToolkit toolkit, String attrName, boolean required) {
            super(client, toolkit, attrName, null, required);
        }

        @Override
        public void modifyAttribute() {
            AbstractConfigDetailsSectionPart.this.editAttribute(this.attr, this.combo.getItem(this.combo.getSelectionIndex()));
        }

        @Override
        public void update() {
            AbstractConfigDetailsSectionPart.this.setComboSelection(this.combo, AbstractConfigDetailsSectionPart.this.getAttributeValue(this.attr));
        }
    }

    protected abstract class XmlBackedHyperlinkTextAttribute
    extends HyperlinkedTextAttribute {
        public XmlBackedHyperlinkTextAttribute(Composite client, FormToolkit toolkit, String attrName) {
            this(client, toolkit, attrName, false);
        }

        public XmlBackedHyperlinkTextAttribute(Composite client, FormToolkit toolkit, String attrName, boolean required) {
            super(client, toolkit, attrName, required);
        }

        @Override
        public void modifyAttribute() {
            AbstractConfigDetailsSectionPart.this.editAttribute(this.attr, this.text.getText());
        }

        @Override
        public void update() {
            AbstractConfigDetailsSectionPart.this.setTextValue(this.text, AbstractConfigDetailsSectionPart.this.getAttributeValue(this.attr));
        }
    }
}

