/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.views.TestResultsView;
import com.atlassian.theplugin.commons.bamboo.TestDetails;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;

public class CopyFailureListAction
extends Action {
    private final Clipboard fClipboard;
    private final TestResultsView fRunner;

    public CopyFailureListAction(TestResultsView runner, Clipboard clipboard) {
        super("Copy Failure List");
        this.fRunner = runner;
        this.fClipboard = clipboard;
    }

    public void run() {
        block3: {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.getAllFailureTraces()}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)"Problem Copying Failure List to Clipboard", (String)"There was a problem when accessing the system clipboard. Retry?")) break block3;
                this.run();
            }
        }
    }

    public String getAllFailureTraces() {
        StringBuffer buf = new StringBuffer();
        List<TestDetails> failures = this.fRunner.getAllFailures();
        String lineDelim = System.getProperty("line.separator", "\n");
        for (TestDetails failure : failures) {
            buf.append(failure.getTestMethodName()).append(lineDelim);
            String failureTrace = failure.getErrors();
            if (failureTrace == null) continue;
            int start = 0;
            while (start < failureTrace.length()) {
                int idx = failureTrace.indexOf(10, start);
                if (idx != -1) {
                    String line = failureTrace.substring(start, idx);
                    buf.append(line).append(lineDelim);
                    start = idx + 1;
                    continue;
                }
                start = Integer.MAX_VALUE;
            }
        }
        return buf.toString();
    }
}

