/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Date;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.views.actions.AbstractViolationSelectionAction;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ReviewAction
extends AbstractViolationSelectionAction {
    private static final Logger log = Logger.getLogger(ReviewAction.class);
    private IProgressMonitor monitor;

    public ReviewAction(TableViewer viewer) {
        super(viewer);
    }

    @Override
    protected String textId() {
        return "view.action.review";
    }

    @Override
    protected String imageId() {
        return "icons/btn_review.gif";
    }

    @Override
    protected String tooltipMsgId() {
        return "view.tooltip.review";
    }

    public void run() {
        final IMarker[] markers = this.getSelectedViolations();
        if (markers == null) {
            return;
        }
        final boolean reviewPmdStyle = ReviewAction.loadPreferences().isReviewPmdStyleEnabled();
        boolean go = ReviewAction.confirmForMultiples(markers, reviewPmdStyle);
        if (go) {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
                dialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ReviewAction.this.setMonitor(monitor);
                        monitor.beginTask(ReviewAction.getString("monitor.review"), 5);
                        ReviewAction.this.insertReview(markers[0], reviewPmdStyle);
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                ReviewAction.logErrorByKey("message.error.invocationtarget_exception", e);
            }
            catch (InterruptedException e) {
                ReviewAction.logErrorByKey("message.error.interrupted_exception", e);
            }
        }
    }

    private static boolean confirmForMultiples(IMarker[] markers, boolean reviewPmdStyle) {
        boolean go = true;
        if (markers.length > 1 && !reviewPmdStyle) {
            String title = ReviewAction.getString("message.confirm.title");
            String message = ReviewAction.getString("message.confirm.review_multiple_markers");
            Shell shell = Display.getCurrent().getActiveShell();
            go = MessageDialog.openConfirm((Shell)shell, (String)title, (String)message);
        }
        return go;
    }

    protected void insertReview(IMarker marker, boolean reviewPmdStyle) {
        try {
            IResource resource = marker.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (file.exists()) {
                    String sourceCode = ReviewAction.readFile(file);
                    this.monitorWorked();
                    int offset = ReviewAction.getMarkerLineStart(sourceCode, marker.getAttribute("lineNumber", 0));
                    this.monitorWorked();
                    sourceCode = reviewPmdStyle ? ReviewAction.addPmdReviewComment(sourceCode, offset, marker) : ReviewAction.addPluginReviewComment(sourceCode, offset, marker);
                    this.monitorWorked();
                    file.setContents((InputStream)new ByteArrayInputStream(sourceCode.getBytes()), false, true, this.getMonitor());
                    this.monitorWorked();
                } else {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)ReviewAction.getString("message.error.title"), (String)("The file " + file.getName() + " doesn't exist, review aborted. Try to refresh the workspace and retry."));
                }
            }
        }
        catch (JavaModelException jme) {
            ReviewAction.ignore(jme);
        }
        catch (CoreException e) {
            ReviewAction.logErrorByKey("message.error.core_exception", e);
        }
        catch (IOException e) {
            ReviewAction.logErrorByKey("message.error.io_exception", e);
        }
    }

    private static void ignore(JavaModelException jme) {
        IJavaModelStatus status = jme.getJavaModelStatus();
        PMDPlugin.getDefault().logError((IStatus)status);
        log.warn((Object)("Ignoring Java Model Exception : " + status.getMessage()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("   code : " + status.getCode()));
            log.debug((Object)("   severity : " + status.getSeverity()));
            IJavaElement[] elements = status.getElements();
            int i = 0;
            while (i < elements.length) {
                log.debug((Object)("   element : " + elements[i].getElementName() + " (" + elements[i].getElementType() + ')'));
                ++i;
            }
        }
    }

    protected IProgressMonitor getMonitor() {
        return this.monitor;
    }

    protected void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private void monitorWorked() {
        if (this.getMonitor() != null) {
            this.getMonitor().worked(1);
        }
    }

    private static int getMarkerLineStart(String sourceCode, int lineNumber) {
        int lineStart = 0;
        int currentLine = 1;
        lineStart = 0;
        while (lineStart < sourceCode.length()) {
            if (currentLine == lineNumber) break;
            if (sourceCode.charAt(lineStart) == '\n') {
                ++currentLine;
            }
            ++lineStart;
        }
        if (sourceCode.charAt(lineStart) == '\r') {
            ++lineStart;
        }
        return lineStart;
    }

    public static String additionalCommentTxt() {
        String additionalCommentPattern = ReviewAction.loadPreferences().getReviewAdditionalComment();
        return MessageFormat.format(additionalCommentPattern, System.getProperty("user.name", ""), new Date());
    }

    private static String addPluginReviewComment(String sourceCode, int offset, IMarker marker) {
        StringBuilder sb = new StringBuilder(sourceCode.substring(0, offset));
        sb.append(ReviewAction.computeIndent(sourceCode, offset));
        sb.append("// @PMD:REVIEWED:");
        sb.append(MarkerUtil.ruleNameFor(marker));
        sb.append(": ").append(ReviewAction.additionalCommentTxt());
        sb.append(System.getProperty("line.separator"));
        sb.append(sourceCode.substring(offset));
        return sb.toString();
    }

    private static String addPmdReviewComment(String sourceCode, int offset, IMarker marker) {
        String result = sourceCode;
        int index = sourceCode.substring(offset).indexOf(13);
        if (index == -1 && (index = sourceCode.substring(offset).indexOf(10)) == -1) {
            index = sourceCode.substring(offset).length();
        }
        if (sourceCode.substring(offset, index += offset).indexOf("// NOPMD") == -1) {
            StringBuilder sb = new StringBuilder(sourceCode.substring(0, index));
            sb.append(' ').append("// NOPMD");
            sb.append(' ').append(ReviewAction.additionalCommentTxt());
            sb.append(sourceCode.substring(index));
            result = sb.toString();
        }
        return result;
    }

    private static String computeIndent(String sourceCode, int offset) {
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (Character.isWhitespace(sourceCode.charAt(offset + i))) {
            indent.append(sourceCode.charAt(offset + i));
            ++i;
        }
        return indent.toString();
    }

    public static String readFile(IFile file) throws IOException, CoreException {
        InputStream contents = file.getContents(true);
        InputStreamReader reader = new InputStreamReader(contents);
        try {
            char[] buffer = new char[4096];
            StringBuilder sb = new StringBuilder(4096);
            while (reader.ready()) {
                int readCount = reader.read(buffer);
                if (readCount == -1) continue;
                sb.append(buffer, 0, readCount);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }
}

