/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.quickfix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.quickfix.Fix;
import net.sourceforge.pmd.eclipse.ui.quickfix.PMDResolution;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class PMDResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final Map<String, Fix[]> fixersByRuleName = new HashMap<String, Fix[]>();
    private static final Set<String> missingFixes = new HashSet<String>();
    private static final Map<String, String> brokenFixes = new HashMap<String, String>();
    private static String QUICKFIX_BUNDLE = "properties.QuickFix";
    public static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];

    public static Class<Fix> fixClassFor(String className, String ruleName) {
        if (StringUtil.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<Fix> cls = Class.forName(className);
            if (Fix.class.isAssignableFrom(cls)) {
                return cls;
            }
            brokenFixes.put(ruleName, className);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static void add(String ruleName, Fix fix) {
        if (fixersByRuleName.containsKey(ruleName)) {
            Fix[] existingFixers = fixersByRuleName.get(ruleName);
            Fix[] newFixers = new Fix[existingFixers.length + 1];
            System.arraycopy(existingFixers, 0, newFixers, 0, existingFixers.length);
            newFixers[newFixers.length - 1] = fix;
            fixersByRuleName.put(ruleName, newFixers);
        } else {
            fixersByRuleName.put(ruleName, new Fix[]{fix});
        }
    }

    public static int fixCountFor(Rule rule) {
        String ruleName = rule.getName();
        if (missingFixes.contains(ruleName)) {
            return 0;
        }
        PMDResolutionGenerator.loadFixesFor(ruleName);
        if (!fixersByRuleName.containsKey(ruleName)) {
            return 0;
        }
        return fixersByRuleName.get(ruleName).length;
    }

    public static void saveFixesFor(String ruleName) {
    }

    private static void loadFixesFor(String ruleName) {
        String[] fixClassNames;
        ResourceBundle bundle = ResourceBundle.getBundle(QUICKFIX_BUNDLE);
        if (!bundle.containsKey(ruleName)) {
            missingFixes.add(ruleName);
            return;
        }
        String fixClassNameSet = bundle.getString(ruleName);
        String[] stringArray = fixClassNames = fixClassNameSet.split(",");
        int n = fixClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            Fix fix;
            Class<Fix> fixClass;
            String fixClassName = stringArray[n2];
            if (!StringUtil.isEmpty((String)fixClassName) && (fixClass = PMDResolutionGenerator.fixClassFor(fixClassName.trim(), ruleName)) != null && (fix = PMDResolutionGenerator.fixFor(ruleName, fixClass)) != null) {
                PMDResolutionGenerator.add(ruleName, fix);
            }
            ++n2;
        }
        if (!fixersByRuleName.containsKey(ruleName)) {
            missingFixes.add(ruleName);
        }
    }

    public static boolean hasFixesFor(Rule rule) {
        String ruleName = rule.getName();
        if (fixersByRuleName.containsKey(ruleName)) {
            return true;
        }
        if (missingFixes.contains(ruleName)) {
            return false;
        }
        if (brokenFixes.containsKey(ruleName)) {
            return false;
        }
        PMDResolutionGenerator.loadFixesFor(ruleName);
        return fixersByRuleName.containsKey(ruleName);
    }

    private static Fix fixFor(String ruleName, Class<Fix> fixClass) {
        try {
            return fixClass.newInstance();
        }
        catch (Exception exception) {
            brokenFixes.put(ruleName, fixClass.getName());
            return null;
        }
    }

    public static Fix[] fixesFor(Rule rule) {
        return fixersByRuleName.get(rule.getName());
    }

    public static void fixesFor(Rule rule, Fix[] fixes) {
        fixersByRuleName.put(rule.getName(), fixes);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<PMDResolution> markerResolutionList = new ArrayList<PMDResolution>();
        try {
            String ruleName = MarkerUtil.ruleNameFor(marker);
            if (ruleName != null) {
                Fix[] fixes;
                RuleSet ruleSet = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
                Rule rule = ruleSet.getRuleByName(ruleName);
                if (rule == null || !PMDResolutionGenerator.hasFixesFor(rule)) {
                    return EMPTY_RESOLUTIONS;
                }
                Fix[] fixArray = fixes = PMDResolutionGenerator.fixesFor(rule);
                int n = fixes.length;
                int n2 = 0;
                while (n2 < n) {
                    Fix fix = fixArray[n2];
                    markerResolutionList.add(new PMDResolution(fix));
                    ++n2;
                }
            }
        }
        catch (RuntimeException e) {
            PMDPlugin.getDefault().showError(PMDPlugin.getDefault().getStringTable().getString("message.error.runtime_exception"), e);
        }
        return markerResolutionList.toArray(new IMarkerResolution[markerResolutionList.size()]);
    }
}

