/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class PMDGenerateASTAction
extends AbstractUIAction
implements IRunnableWithProgress {
    private static final Logger log = Logger.getLogger(PMDGenerateASTAction.class);
    private IStructuredSelection structuredSelection;

    public void run(IAction action) {
        ISelection sel;
        log.info((Object)"Generation AST action requested");
        if (this.isViewPart() && (sel = this.targetSelection()) instanceof IStructuredSelection) {
            this.structuredSelection = (IStructuredSelection)sel;
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                dialog.run(false, false, (IRunnableWithProgress)this);
            }
            catch (InvocationTargetException e) {
                this.showErrorById("message.error.invocationtarget_exception", e);
            }
            catch (InterruptedException e) {
                this.showErrorById("message.error.interrupted_exception", e);
            }
        }
        if (this.isEditorPart()) {
            IEditorInput editorInput = ((IEditorPart)this.targetPart()).getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                this.generateAST(((IFileEditorInput)editorInput).getFile());
            } else {
                log.debug((Object)("The kind of editor input is not supported. The editor input if of type: " + editorInput.getClass().getName()));
            }
        } else {
            log.debug((Object)("This action is not supported on this kind of part. This part type is: " + this.targetPartClassName()));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    /*
     * Exception decompiling
     */
    private void generateAST(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IFile createASTFile(IFile file) {
        String astName = PMDGenerateASTAction.astNameFor(file);
        IFile astFile = null;
        IContainer parent = file.getParent();
        if (parent instanceof IFolder) {
            astFile = ((IFolder)parent).getFile(astName);
        } else if (parent instanceof IProject) {
            astFile = ((IProject)parent).getFile(astName);
        }
        return astFile;
    }

    private static String astNameFor(IFile file) {
        String name = file.getName();
        int dotPosition = name.indexOf(46);
        String astName = String.valueOf(name.substring(0, dotPosition)) + ".ast";
        return astName;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("", this.structuredSelection.size());
        for (Object element : this.structuredSelection) {
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                IResource resource = (IResource)adaptable.getAdapter(IResource.class);
                if (resource != null) {
                    monitor.subTask(resource.getName());
                    this.generateAST((IFile)resource);
                    monitor.worked(1);
                    continue;
                }
                log.warn((Object)"The selected object cannot adapt to a resource");
                log.debug((Object)("   -> selected object : " + element));
                continue;
            }
            log.warn((Object)"The selected object is not adaptable");
            log.debug((Object)("   -> selected object : " + element));
        }
    }
}

