/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;

public class ReviewResourceForRuleCommand
extends AbstractDefaultCommand {
    private static final long serialVersionUID = 1L;
    private IResource resource;
    private RuleContext context;
    private Rule rule;
    private List<IPropertyListener> listenerList;

    public ReviewResourceForRuleCommand() {
        super("ReviewResourceForRuleCommand", "Review a resource for a specific rule.");
        this.setOutputProperties(true);
        this.setReadOnly(true);
        this.setTerminated(false);
        this.listenerList = new ArrayList<IPropertyListener>();
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public boolean isReadyToExecute() {
        return this.resource != null && this.rule != null;
    }

    @Override
    public void reset() {
        this.setResource(null);
        this.setRule(null);
        this.listenerList = new ArrayList<IPropertyListener>();
    }

    @Override
    public void execute() throws CommandException {
        IFile file = (IFile)this.resource.getAdapter(IFile.class);
        this.beginTask("PMD checking for rule: " + this.rule.getName(), 1);
        if (file != null) {
            RuleSet ruleSet = new RuleSet();
            ruleSet.addRule(this.rule);
            File sourceCodeFile = file.getFullPath().toFile();
            if (ruleSet.applies(sourceCodeFile)) {
                try {
                    this.context = PMD.newRuleContext((String)file.getName(), (File)sourceCodeFile);
                    RuleSets rSets = new RuleSets(ruleSet);
                    new SourceCodeProcessor(new PMDConfiguration()).processSourceCode(file.getContents(), rSets, this.context);
                }
                catch (PMDException e) {
                    throw new CommandException(e);
                }
                catch (CoreException e) {
                    throw new CommandException(e);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (IPropertyListener listener : ReviewResourceForRuleCommand.this.listenerList) {
                            listener.propertyChanged((Object)ReviewResourceForRuleCommand.this.context.getReport().iterator(), 1112);
                        }
                    }
                });
            }
        }
    }
}

