/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelProvider;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabels;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataReference;
import org.springframework.ide.eclipse.beans.ui.model.metadata.BeanMetadataUtils;
import org.springframework.ide.eclipse.beans.ui.model.metadata.IBeanMetadataLabelProvider;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceLabelProvider;
import org.springframework.ide.eclipse.beans.ui.namespaces.NamespaceUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;

public class BeansNavigatorLabelProvider
extends BeansModelLabelProvider
implements ICommonLabelProvider,
IFontProvider,
IColorProvider {
    private Color grayColor = new Color((Device)Display.getDefault(), 150, 150, 150);
    private String providerID;

    public BeansNavigatorLabelProvider() {
        super(true);
    }

    public BeansNavigatorLabelProvider(boolean isDecorating) {
        super(isDecorating);
    }

    public void init(ICommonContentExtensionSite config) {
        this.providerID = config.getExtension().getId();
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public String getDescription(Object element) {
        IBeanMetadataLabelProvider labelProvider;
        if (element instanceof IBeanMetadata && (labelProvider = BeanMetadataUtils.getLabelProvider((IBeanMetadata)element)) != null) {
            labelProvider.getDescription(element);
        }
        if (element instanceof IBeansProject) {
            return "Beans - " + ((IBeansProject)element).getProject().getName();
        }
        if (element instanceof ISourceModelElement) {
            INamespaceLabelProvider provider = NamespaceUtils.getLabelProvider((ISourceModelElement)element);
            if (provider != null && provider instanceof IDescriptionProvider) {
                return ((IDescriptionProvider)provider).getDescription(element);
            }
            return DEFAULT_NAMESPACE_LABEL_PROVIDER.getDescription(element);
        }
        if (element instanceof IModelElement) {
            return BeansModelLabels.getElementLabel((IModelElement)element, 6);
        }
        if (element instanceof IFile) {
            IBeansConfig config = BeansCorePlugin.getModel().getConfig((IFile)element);
            if (config != null) {
                return BeansModelLabels.getElementLabel((IModelElement)config, 6);
            }
        } else {
            if (element instanceof ZipEntryStorage) {
                ZipEntryStorage storage = (ZipEntryStorage)element;
                StringBuilder builder = new StringBuilder();
                builder.append(storage.getFullPath().lastSegment());
                builder.append(" - ");
                builder.append(storage.getFullPath().removeLastSegments(1).toString());
                builder.append(" - ");
                builder.append(storage.getFile().getFullPath().toString());
                return builder.toString();
            }
            if (element instanceof BeanMetadataReference && BeanMetadataUtils.getLabelProvider((BeanMetadataReference)element) != null) {
                return BeanMetadataUtils.getLabelProvider((BeanMetadataReference)element).getDescription(element);
            }
        }
        return null;
    }

    public String toString() {
        return this.providerID;
    }

    protected String getProviderID() {
        return this.providerID;
    }

    public void dispose() {
        super.dispose();
        if (this.grayColor != null) {
            this.grayColor.dispose();
        }
    }

    @Override
    protected Image getImage(Object element, Object parentElement) {
        if (element instanceof IBeansProject) {
            Image image = BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.virtual_folder_obj.gif");
            return image;
        }
        return super.getImage(element, parentElement);
    }

    @Override
    protected String getText(Object element, Object parentElement) {
        if (element instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)element).isInitialized()) {
            return "initializing...";
        }
        if (element instanceof IBeansProject) {
            return "Beans";
        }
        if (element instanceof IBeansConfig && (parentElement instanceof ISpringProject || parentElement instanceof IBeansProject)) {
            return ((IBeansConfig)element).getElementName();
        }
        if (element instanceof IFile && parentElement instanceof IModelElement) {
            return String.valueOf(((IFile)element).getName()) + " - " + ((IFile)element).getProjectRelativePath().removeLastSegments(1).toString();
        }
        return super.getText(element, parentElement);
    }

    public Font getFont(Object element) {
        if (element instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)element).isInitialized()) {
            return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)element).isInitialized()) {
            return this.grayColor;
        }
        return null;
    }
}

