/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.io.EclipsePathMatchingResourcePatternResolver;
import org.springframework.ide.eclipse.core.io.InputStreamUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.util.StringUtils;

public class ExternalFile
extends AbstractResource
implements IFile {
    private final File file;
    private final String entryName;
    private final IProject project;
    private final Map<Long, ExternalMarker> markers = new ConcurrentHashMap<Long, ExternalMarker>();
    private final AtomicLong markerId = new AtomicLong();

    public ExternalFile(File file, String entryName, IProject project) {
        this.file = file;
        this.project = project;
        this.entryName = entryName;
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public String getCharset() throws CoreException {
        return null;
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        return null;
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        return null;
    }

    public IContentDescription getContentDescription() throws CoreException {
        return null;
    }

    public InputStream getContents() throws CoreException {
        try {
            ZipEntry entry;
            ZipFile file = new ZipFile(this.file);
            String cleanedEntryName = this.entryName;
            if (cleanedEntryName.length() > 1 && cleanedEntryName.charAt(0) == '/') {
                cleanedEntryName = cleanedEntryName.substring(1);
            }
            if ((entry = file.getEntry(cleanedEntryName)) == null) {
                throw new CoreException(SpringCore.createErrorStatus("Invalid path '" + cleanedEntryName + "'", null));
            }
            return InputStreamUtils.getWrappedInputStream(file, entry);
        }
        catch (IOException e) {
            throw new CoreException(SpringCore.createErrorStatus(e.getMessage(), e));
        }
    }

    public InputStream getContents(boolean force) throws CoreException {
        return this.getContents();
    }

    public int getEncoding() throws CoreException {
        return 0;
    }

    public IPath getFullPath() {
        return new Path(this.getFilename());
    }

    public IFileState[] getHistory(IProgressMonitor monitor) throws CoreException {
        return new IFileState[0];
    }

    public String getName() {
        return this.entryName;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void setCharset(String newCharset) throws CoreException {
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
    }

    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
    }

    public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
    }

    public void clearHistory(IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public Resource createRelative(String relativePath) throws IOException {
        String pathToUse = StringUtils.applyRelativePath((String)this.entryName, (String)relativePath);
        return new EclipsePathMatchingResourcePatternResolver(this.project).getResource(pathToUse);
    }

    public IMarker createMarker(String type) throws CoreException {
        long id = this.markerId.incrementAndGet();
        ExternalMarker marker = new ExternalMarker(id, type, this);
        this.markers.put(id, marker);
        return marker;
    }

    public IResourceProxy createProxy() {
        return null;
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
    }

    public boolean exists() {
        return this.file.exists();
    }

    public IMarker findMarker(long id) throws CoreException {
        return this.markers.get(id);
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        HashSet<ExternalMarker> newMarkers = new HashSet<ExternalMarker>();
        for (ExternalMarker marker : this.markers.values()) {
            if (!marker.getType().equals(type) && (!includeSubtypes || !marker.isSubtypeOf(type))) continue;
            newMarkers.add(marker);
        }
        return newMarkers.toArray(new IMarker[newMarkers.size()]);
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
        return 0;
    }

    public String getFileExtension() {
        return this.file.getName();
    }

    public long getLocalTimeStamp() {
        return this.file.lastModified();
    }

    public IPath getLocation() {
        return new Path(this.file.getAbsolutePath());
    }

    public URI getLocationURI() {
        return this.file.toURI();
    }

    public IMarker getMarker(long id) {
        return this.markers.get(id);
    }

    public long getModificationStamp() {
        return this.file.lastModified();
    }

    public IContainer getParent() {
        return this.project;
    }

    public Map getPersistentProperties() throws CoreException {
        return Collections.EMPTY_MAP;
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        return key.getQualifier();
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getProjectRelativePath() {
        return new Path(this.file.getAbsolutePath());
    }

    public IPath getRawLocation() {
        return new Path(this.getFilename());
    }

    public URI getRawLocationURI() {
        return this.file.toURI();
    }

    public ResourceAttributes getResourceAttributes() {
        return null;
    }

    public Map getSessionProperties() throws CoreException {
        return null;
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        return null;
    }

    public int getType() {
        return 1;
    }

    public IWorkspace getWorkspace() {
        return this.project.getWorkspace();
    }

    public boolean isAccessible() {
        return true;
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isDerived(int options) {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isLinked() {
        return false;
    }

    public boolean isLinked(int options) {
        return false;
    }

    public boolean isLocal(int depth) {
        return false;
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean isSynchronized(int depth) {
        return false;
    }

    public boolean isTeamPrivateMember() {
        return false;
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
    }

    public void revertModificationStamp(long value) throws CoreException {
    }

    public void setDerived(boolean isDerived) throws CoreException {
    }

    public void setHidden(boolean isHidden) throws CoreException {
    }

    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        return 0L;
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
    }

    public void setReadOnly(boolean readOnly) {
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ZipEntryStorage.class) {
            return new ZipEntryStorage(this, this.entryName);
        }
        if (adapter == IResource.class) {
            return this;
        }
        return null;
    }

    public boolean contains(ISchedulingRule rule) {
        return this == rule;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this == rule;
    }

    public String getDescription() {
        return "external resource [" + this.getFilename() + "]";
    }

    public String getFilename() throws IllegalStateException {
        return String.valueOf(this.file.getAbsolutePath()) + "!" + this.entryName;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public File getFile() throws IOException {
        return this.file;
    }

    public boolean isHidden(int options) {
        return false;
    }

    public boolean isTeamPrivateMember(int options) {
        return false;
    }

    public boolean hasFilters() {
        return false;
    }

    public boolean isVirtual() {
        return true;
    }

    public void setDerived(boolean arg0, IProgressMonitor arg1) throws CoreException {
    }

    public IPathVariableManager getPathVariableManager() {
        return ResourcesPlugin.getWorkspace().getPathVariableManager();
    }

    public boolean isFiltered() {
        return false;
    }

    class ExternalMarker
    implements IMarker {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final long creationTime = System.currentTimeMillis();
        private final long id;
        private final ExternalFile resource;
        private final String type;

        ExternalMarker(long id, String type, ExternalFile resource) {
            this.id = id;
            this.type = type;
            this.resource = resource;
        }

        public void delete() throws CoreException {
            this.resource.markers.remove(this.id);
        }

        public boolean exists() {
            return true;
        }

        public Object getAttribute(String attributeName) throws CoreException {
            return this.attributes.get(attributeName);
        }

        public int getAttribute(String attributeName, int defaultValue) {
            return this.attributes.containsKey(attributeName) ? (Integer)this.attributes.get(attributeName) : defaultValue;
        }

        public String getAttribute(String attributeName, String defaultValue) {
            return this.attributes.containsKey(attributeName) ? (String)this.attributes.get(attributeName) : defaultValue;
        }

        public boolean getAttribute(String attributeName, boolean defaultValue) {
            return this.attributes.containsKey(attributeName) ? (Boolean)this.attributes.get(attributeName) : defaultValue;
        }

        public Map getAttributes() throws CoreException {
            return this.attributes;
        }

        public Object[] getAttributes(String[] attributeNames) throws CoreException {
            return null;
        }

        public long getCreationTime() throws CoreException {
            return this.creationTime;
        }

        public long getId() {
            return this.id;
        }

        public IResource getResource() {
            return this.resource;
        }

        public String getType() throws CoreException {
            return this.type;
        }

        public boolean isSubtypeOf(String superType) throws CoreException {
            return ((Workspace)ExternalFile.this.getWorkspace()).getMarkerManager().isSubtype(this.getType(), this.type);
        }

        public void setAttribute(String attributeName, int value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, Object value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttribute(String attributeName, boolean value) throws CoreException {
            this.attributes.put(attributeName, value);
        }

        public void setAttributes(Map attributes) throws CoreException {
            this.attributes.putAll(attributes);
        }

        public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
            int i = 0;
            while (i < attributeNames.length) {
                this.setAttribute(attributeNames[i], values[i]);
                ++i;
            }
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }
}

