/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure.ui;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfo;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoElement;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoPage;

public class WizardUIInfoLoader {
    public WizardUIInfo load(InputStream jsonDescriptionInputStream) throws IOException {
        return this.load(new InputStreamReader(jsonDescriptionInputStream));
    }

    public WizardUIInfo load(Reader jsonDescriptionReader) throws IOException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        xstream.alias("info", WizardUIInfo.class);
        xstream.alias("element", WizardUIInfoElement.class);
        xstream.alias("page", WizardUIInfoPage.class);
        return (WizardUIInfo)xstream.fromXML(jsonDescriptionReader);
    }

    public WizardUIInfo load(String jsonDescriptionFile) throws IOException {
        return this.load(new FileReader(jsonDescriptionFile));
    }

    public WizardUIInfo getUIInfo(Template template) throws CoreException {
        WizardUIInfo info;
        if (template == null) {
            return null;
        }
        URL jsonWizardUIDescriptor = template.getTemplateLocation();
        if (jsonWizardUIDescriptor == null) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to find json descriptor for template: " + template.getName() + ". Missing URL to template location."));
        }
        try {
            InputStream jsonDescriptionInputStream = jsonWizardUIDescriptor.openStream();
            info = this.load(jsonDescriptionInputStream);
        }
        catch (IOException ex) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to load json descriptor for wizard page due to: " + ex.getMessage(), (Throwable)ex));
        }
        catch (XStreamException ex) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to load json descriptor for wizard page due to: " + ex.getMessage(), (Throwable)ex));
        }
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Unable to find template project location"));
        }
        return info;
    }
}

