/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.ModelTableLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.PropertiesContentProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;

public class AttributeSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private IAttributeEnabled state;
    private IAttributeEnabled oldState;
    private TableViewer configsViewer;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        Table configsTable = this.getWidgetFactory().createTable(composite, 66306);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        data.height = 70;
        configsTable.setLayoutData((Object)data);
        TableColumn columnName = new TableColumn(configsTable, 0);
        columnName.setText("Name");
        columnName.setWidth(150);
        TableColumn columnValue = new TableColumn(configsTable, 0);
        columnValue.setText("Value");
        columnValue.setWidth(120);
        TableColumn columnType = new TableColumn(configsTable, 0);
        columnType.setText("Type");
        columnType.setWidth(80);
        configsTable.setHeaderVisible(true);
        this.configsViewer = new TableViewer(configsTable);
        String[] columnNames = new String[]{"Name", "Value", "Type"};
        this.configsViewer.setColumnProperties(columnNames);
        this.configsViewer.setContentProvider((IContentProvider)new PropertiesContentProvider(this.state, this.configsViewer));
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ModelTableLabelProvider());
        this.configsViewer.setInput((Object)this.state);
        configsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        CLabel labelLabel = this.getWidgetFactory().createCLabel(composite, "Attributes:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)configsTable, -5);
        data.top = new FormAttachment((Control)configsTable, 0, 128);
        labelLabel.setLayoutData((Object)data);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (this.oldState != null) {
            this.oldState.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (input instanceof AbstractStatePart && ((AbstractStatePart)input).getModel() instanceof IAttributeEnabled) {
            this.state = (IAttributeEnabled)((AbstractStatePart)input).getModel();
        }
    }

    public void refresh() {
        this.configsViewer.setContentProvider((IContentProvider)new PropertiesContentProvider(this.state, this.configsViewer));
        this.configsViewer.setInput((Object)this.state);
        this.configsViewer.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh();
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.dispose();
    }
}

