/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.workingsets.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class WorkingSetRootModeActionGroup
extends ActionGroup {
    private IExtensionStateModel stateModel;
    private StructuredViewer structuredViewer;
    private boolean hasContributedToViewMenu = false;
    private IAction workingSetsAction = null;
    private IAction projectsAction = null;
    private IAction[] actions;
    private int currentSelection;
    private MenuItem[] items;

    public WorkingSetRootModeActionGroup(StructuredViewer aStructuredViewer, IExtensionStateModel aStateModel) {
        this.structuredViewer = aStructuredViewer;
        this.stateModel = aStateModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillActionBars(IActionBars actionBars) {
        if (!this.hasContributedToViewMenu) {
            WorkingSetRootModeActionGroup workingSetRootModeActionGroup = this;
            synchronized (workingSetRootModeActionGroup) {
                if (!this.hasContributedToViewMenu) {
                    this.hasContributedToViewMenu = true;
                    this.contributeToViewMenu(actionBars.getMenuManager());
                }
            }
        }
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        MenuManager topLevelSubMenu = new MenuManager(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Top_Level_Element_);
        Separator marker = new Separator("topLevelElements");
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)marker);
        viewMenu.appendToGroup("topLevelElements", (IContributionItem)topLevelSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)topLevelSubMenu);
    }

    protected void addActions(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new Separator());
        this.items = new MenuItem[this.actions.length];
        int i = 0;
        while (i < this.actions.length) {
            final int j = i++;
            viewMenu.add((IContributionItem)new ContributionItem(){

                public void fill(Menu menu, int index) {
                    MenuItem mi;
                    int style = 32;
                    if ((WorkingSetRootModeActionGroup.this.actions[j].getStyle() & 8) != 0) {
                        style = 16;
                    }
                    ((WorkingSetRootModeActionGroup)WorkingSetRootModeActionGroup.this).items[j] = mi = new MenuItem(menu, style, index);
                    mi.setText(WorkingSetRootModeActionGroup.this.actions[j].getText());
                    mi.setSelection(WorkingSetRootModeActionGroup.this.currentSelection == j);
                    mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (WorkingSetRootModeActionGroup.this.currentSelection == j) {
                                WorkingSetRootModeActionGroup.this.items[WorkingSetRootModeActionGroup.this.currentSelection].setSelection(true);
                                return;
                            }
                            WorkingSetRootModeActionGroup.this.actions[j].run();
                            WorkingSetRootModeActionGroup.this.items[WorkingSetRootModeActionGroup.this.currentSelection].setSelection(false);
                            WorkingSetRootModeActionGroup.this.currentSelection = j;
                            WorkingSetRootModeActionGroup.this.items[WorkingSetRootModeActionGroup.this.currentSelection].setSelection(true);
                        }
                    });
                }

                public boolean isDynamic() {
                    return false;
                }
            });
        }
    }

    private IAction[] createActions() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.projectsAction = new TopLevelContentAction(false);
        this.projectsAction.setText(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Project_);
        this.projectsAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_OBJ_PROJECT"));
        this.workingSetsAction = new TopLevelContentAction(true);
        this.workingSetsAction.setText(WorkbenchNavigatorMessages.WorkingSetRootModeActionGroup_Working_Set_);
        this.workingSetsAction.setImageDescriptor(WorkbenchNavigatorPlugin.getDefault().getImageRegistry().getDescriptor("full/obj16/workingsets.gif"));
        return new IAction[]{this.projectsAction, this.workingSetsAction};
    }

    public void setShowTopLevelWorkingSets(boolean showTopLevelWorkingSets) {
        if (this.actions == null) {
            this.actions = this.createActions();
            this.setActions(this.actions, showTopLevelWorkingSets ? 1 : 0);
        }
        this.workingSetsAction.setChecked(showTopLevelWorkingSets);
        this.projectsAction.setChecked(!showTopLevelWorkingSets);
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                this.items[i].setSelection(this.actions[i].isChecked());
                ++i;
            }
        }
        if (this.stateModel != null) {
            this.stateModel.setBooleanProperty("org.springframework.ide.eclipse.ui.navigator.workingsets.showTopLevelWorkingSets", showTopLevelWorkingSets);
        }
    }

    private void setActions(IAction[] theActions, int selected) {
        this.actions = theActions;
        this.currentSelection = selected;
    }

    public void setStateModel(IExtensionStateModel sStateModel) {
        this.stateModel = sStateModel;
    }

    private class TopLevelContentAction
    extends Action
    implements IAction {
        private final boolean groupWorkingSets;

        public TopLevelContentAction(boolean toGroupWorkingSets) {
            super("", 8);
            this.groupWorkingSets = toGroupWorkingSets;
        }

        public void run() {
            if (WorkingSetRootModeActionGroup.this.stateModel.getBooleanProperty("org.springframework.ide.eclipse.ui.navigator.workingsets.showTopLevelWorkingSets") != this.groupWorkingSets) {
                WorkingSetRootModeActionGroup.this.stateModel.setBooleanProperty("org.springframework.ide.eclipse.ui.navigator.workingsets.showTopLevelWorkingSets", this.groupWorkingSets);
                WorkingSetRootModeActionGroup.this.structuredViewer.getControl().setRedraw(false);
                try {
                    WorkingSetRootModeActionGroup.this.structuredViewer.refresh();
                }
                finally {
                    WorkingSetRootModeActionGroup.this.structuredViewer.getControl().setRedraw(true);
                }
            }
        }
    }
}

