/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.quickfix.Activator;

public class QuickfixImages {
    private static final URL baseURL = Activator.getDefault().getBundle().getEntry("/icons/");
    private static final String OBJ = "obj16/";
    public static final ImageDescriptor ANNOTATION = QuickfixImages.create("obj16/", "annotation_obj.gif");
    public static final ImageDescriptor LOCAL_VARIABLE = QuickfixImages.create("obj16/", "localvariable_obj.gif");
    public static final ImageDescriptor REMOVE_CORRECTION = QuickfixImages.create("obj16/", "remove_correction.gif");
    public static final ImageDescriptor CLASS = QuickfixImages.create("obj16/", "class_obj.gif");
    public static final ImageDescriptor PACKAGE = QuickfixImages.create("obj16/", "package_obj.gif");
    private static ImageRegistry imageRegistry;

    public static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)QuickfixImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = QuickfixImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("full");
        buffer.append('/');
        buffer.append(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }
}

