/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import java.util.LinkedList;
import java.util.List;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.projectconfig.FileMatchPattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.core.resources.IFile;

public class FileSet
implements Cloneable {
    private String mName;
    private ICheckConfiguration mCheckConfig;
    private boolean mEnabled = true;
    private List<FileMatchPattern> mFileMatchPatterns = new LinkedList<FileMatchPattern>();

    public FileSet() {
    }

    public FileSet(String name, ICheckConfiguration checkConfig) {
        this.setName(name);
        this.setCheckConfig(checkConfig);
    }

    public List<FileMatchPattern> getFileMatchPatterns() {
        return this.mFileMatchPatterns;
    }

    public void setFileMatchPatterns(List<FileMatchPattern> list) {
        this.mFileMatchPatterns = list;
    }

    public ICheckConfiguration getCheckConfig() {
        return this.mCheckConfig;
    }

    public void setCheckConfig(ICheckConfiguration checkConfig) {
        this.mCheckConfig = checkConfig;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean includesFile(IFile file) {
        boolean result = false;
        String filePath = file.getProjectRelativePath().toString();
        for (FileMatchPattern pattern : this.mFileMatchPatterns) {
            boolean matches = pattern.isMatch(filePath);
            if (!matches) continue;
            result = pattern.isIncludePattern();
        }
        return result;
    }

    public FileSet clone() {
        try {
            FileSet clone = (FileSet)super.clone();
            LinkedList<FileMatchPattern> clonedPatterns = new LinkedList<FileMatchPattern>();
            for (FileMatchPattern pattern : this.mFileMatchPatterns) {
                clonedPatterns.add(pattern.clone());
            }
            clone.mFileMatchPatterns = clonedPatterns;
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FileSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FileSet rhs = (FileSet)obj;
        return new EqualsBuilder().append(this.mEnabled, rhs.mEnabled).append((Object)this.mName, (Object)rhs.mName).append(this.mFileMatchPatterns, rhs.mFileMatchPatterns).append((Object)this.mCheckConfig, (Object)rhs.mCheckConfig).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(987349, 1000003).append(this.mEnabled).append((Object)this.mName).append((Object)this.mCheckConfig).append(this.mFileMatchPatterns).toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

