/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanLookupMethodOverride;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanProperty;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReplaceMethodOverride;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansConfig;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanMethodOverride;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansComponent;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.util.ObjectUtils;

public class Bean
extends AbstractBeansModelElement
implements IBean {
    private BeanDefinition definition;
    private String[] aliases;
    private Set<IBeanConstructorArgument> constructorArguments;
    private Set<IBeanMethodOverride> methodOverrides;
    private Map<String, IBeanProperty> properties;
    private Integer hashCode = null;
    private Boolean isFactory = null;

    public Bean(IModelElement parent, BeanDefinitionHolder bdHolder) {
        this(parent, bdHolder.getBeanName(), bdHolder.getAliases(), bdHolder.getBeanDefinition());
    }

    public Bean(IModelElement parent, String name, String[] aliases, BeanDefinition definition) {
        super(parent, name, (BeanMetadataElement)definition);
        this.definition = definition instanceof ScannedGenericBeanDefinition ? new BeansConfig.InternalScannedGenericBeanDefinition((ScannedGenericBeanDefinition)definition) : definition;
        this.aliases = aliases;
        ConstructorArgumentValues cargValues = definition.getConstructorArgumentValues();
        for (Object cargValue : cargValues.getGenericArgumentValues()) {
            this.cleanValueHolder((ConstructorArgumentValues.ValueHolder)cargValue);
        }
        Map indexedCargValues = cargValues.getIndexedArgumentValues();
        for (Object key : indexedCargValues.keySet()) {
            this.cleanValueHolder((ConstructorArgumentValues.ValueHolder)indexedCargValues.get(key));
        }
    }

    public int getElementType() {
        return 8;
    }

    protected String getUniqueElementName() {
        if (this.isInnerBean()) {
            return ":" + this.getElementStartLine();
        }
        return super.getUniqueElementName();
    }

    public IResource getElementResource() {
        IResource resource;
        if (this.getElementSourceLocation() != null && this.getElementSourceLocation().getResource() instanceof IAdaptable && (resource = (IResource)((IAdaptable)this.getElementSourceLocation().getResource()).getAdapter(IResource.class)) != null) {
            return resource;
        }
        return super.getElementResource();
    }

    public IModelElement[] getElementChildren() {
        LinkedHashSet<IBeanConstructorArgument> children = new LinkedHashSet<IBeanConstructorArgument>(this.getConstructorArguments());
        children.addAll(this.getMethodOverrides());
        children.addAll(this.getProperties());
        return children.toArray(new IModelElement[children.size()]);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IBeanConstructorArgument carg : this.getConstructorArguments()) {
                carg.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
            for (IBeanMethodOverride mo : this.getMethodOverrides()) {
                mo.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
            for (IBeanProperty property : this.getProperties()) {
                property.accept(visitor, monitor);
                if (!monitor.isCanceled()) continue;
                return;
            }
        }
    }

    public BeanDefinition getBeanDefinition() {
        return this.definition;
    }

    @Override
    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public Set<IBeanConstructorArgument> getConstructorArguments() {
        if (this.constructorArguments == null) {
            this.initBean();
        }
        return this.constructorArguments;
    }

    @Override
    public Set<IBeanMethodOverride> getMethodOverrides() {
        if (this.methodOverrides == null) {
            this.initBean();
        }
        return this.methodOverrides;
    }

    @Override
    public IBeanProperty getProperty(String name) {
        if (name != null) {
            if (this.properties == null) {
                this.initBean();
            }
            return this.properties.get(name);
        }
        return null;
    }

    @Override
    public Collection<IBeanProperty> getProperties() {
        if (this.properties == null) {
            this.initBean();
        }
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public String getClassName() {
        if (this.definition instanceof AbstractBeanDefinition) {
            return ((AbstractBeanDefinition)this.definition).getBeanClassName();
        }
        return null;
    }

    @Override
    public String getParentName() {
        return this.definition.getParentName();
    }

    @Override
    public boolean isRootBean() {
        return !this.isChildBean();
    }

    @Override
    public boolean isChildBean() {
        return this.definition.getParentName() != null;
    }

    @Override
    public boolean isInnerBean() {
        IModelElement parent = this.getElementParent();
        return !(parent instanceof IBeansConfig) && !(parent instanceof IBeansComponent);
    }

    @Override
    public boolean isSingleton() {
        if (this.definition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition beanDefinition = (AbstractBeanDefinition)this.definition;
            return beanDefinition.getScope() == null || "singleton".equals(beanDefinition.getScope()) || beanDefinition.isSingleton();
        }
        return true;
    }

    @Override
    public boolean isAbstract() {
        if (this.definition instanceof AbstractBeanDefinition) {
            return ((AbstractBeanDefinition)this.definition).isAbstract();
        }
        return false;
    }

    @Override
    public boolean isLazyInit() {
        if (this.definition instanceof AbstractBeanDefinition) {
            return ((AbstractBeanDefinition)this.definition).isLazyInit();
        }
        return true;
    }

    @Override
    public boolean isInfrastructure() {
        if (this.definition instanceof AbstractBeanDefinition) {
            return ((AbstractBeanDefinition)this.definition).getRole() == 2;
        }
        return false;
    }

    @Override
    public boolean isGeneratedElementName() {
        BeanMetadataAttribute attribute;
        if (this.definition instanceof AbstractBeanDefinition && (attribute = ((AbstractBeanDefinition)this.definition).getMetadataAttribute("org.springframework.ide.eclipse.beans.core.GENERATED_BEAN_NAME")) != null && attribute.getValue() instanceof Boolean) {
            return (Boolean)attribute.getValue();
        }
        return false;
    }

    @Override
    public synchronized boolean isFactory() {
        if (this.isFactory == null && this.definition instanceof AbstractBeanDefinition) {
            this.isFactory = Boolean.FALSE;
            AbstractBeanDefinition bd = (AbstractBeanDefinition)this.definition;
            if (bd.getFactoryBeanName() != null) {
                this.isFactory = Boolean.TRUE;
            } else if (this.isRootBean() && bd.getFactoryMethodName() != null) {
                this.isFactory = Boolean.TRUE;
            } else {
                IType type = BeansModelUtils.getBeanType(this, null);
                if (type != null) {
                    this.isFactory = JdtUtils.doesImplement((IResource)this.getElementResource(), (IType)type, (String)FactoryBean.class.getName());
                }
            }
        }
        return this.isFactory;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bean)) {
            return false;
        }
        Bean that = (Bean)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.definition, (Object)that.definition)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.aliases, (Object)that.aliases)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = ObjectUtils.nullSafeHashCode((Object)this.definition);
            this.hashCode = this.getElementType() * this.hashCode + ObjectUtils.nullSafeHashCode((Object[])this.aliases);
            this.hashCode = this.getElementType() * super.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        if (this.getClassName() != null) {
            text.append(" [");
            text.append(this.getClassName());
            text.append(']');
        } else if (this.getParentName() != null) {
            text.append(" <");
            text.append(this.getParentName());
            text.append('>');
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBean() {
        Bean bean = this;
        synchronized (bean) {
            this.constructorArguments = new LinkedHashSet<IBeanConstructorArgument>();
            ConstructorArgumentValues cargValues = this.definition.getConstructorArgumentValues();
            for (Object cargValue : cargValues.getGenericArgumentValues()) {
                BeanConstructorArgument carg = new BeanConstructorArgument(this, (ConstructorArgumentValues.ValueHolder)cargValue);
                this.constructorArguments.add(carg);
            }
            Map indexedCargValues = cargValues.getIndexedArgumentValues();
            for (Object key : indexedCargValues.keySet()) {
                ConstructorArgumentValues.ValueHolder vHolder = (ConstructorArgumentValues.ValueHolder)indexedCargValues.get(key);
                BeanConstructorArgument carg = new BeanConstructorArgument(this, (Integer)key, vHolder);
                this.constructorArguments.add(carg);
            }
            this.properties = new LinkedHashMap<String, IBeanProperty>();
            PropertyValue[] propertyValueArray = this.definition.getPropertyValues().getPropertyValues();
            int n = propertyValueArray.length;
            int carg = 0;
            while (carg < n) {
                PropertyValue propValue = propertyValueArray[carg];
                BeanProperty property = new BeanProperty(this, propValue);
                this.properties.put(property.getElementName(), property);
                ++carg;
            }
            if (this.definition instanceof AbstractBeanDefinition) {
                this.methodOverrides = new LinkedHashSet<IBeanMethodOverride>();
                MethodOverrides mos = ((AbstractBeanDefinition)this.definition).getMethodOverrides();
                if (mos != null) {
                    for (Object mo : mos.getOverrides()) {
                        if (mo instanceof LookupOverride) {
                            this.methodOverrides.add(new BeanLookupMethodOverride(this, (LookupOverride)mo));
                            continue;
                        }
                        if (!(mo instanceof ReplaceOverride)) continue;
                        this.methodOverrides.add(new BeanReplaceMethodOverride(this, (ReplaceOverride)mo));
                    }
                }
            }
        }
    }

    private ConstructorArgumentValues.ValueHolder cleanValueHolder(ConstructorArgumentValues.ValueHolder vHolder) {
        if (vHolder.getValue() instanceof ResourceLoader) {
            vHolder.setValue((Object)vHolder.getValue().getClass().getName());
        }
        return vHolder;
    }
}

