/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.springsource.ide.eclipse.commons.livexp.core.CompositeValidator;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.PreferencePageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.PrefsPageSection;

public class PrefsGroupSection
extends PrefsPageSection {
    private List<PrefsPageSection> sections;
    private CompositeValidator validator;
    private String groupTitle;
    public final LiveVariable<Boolean> isVisible = new LiveVariable<Boolean>(true);

    public PrefsGroupSection(PreferencePageWithSections owner, String title, PrefsPageSection ... _sections) {
        super(owner);
        this.groupTitle = title;
        this.sections = new ArrayList<PrefsPageSection>();
        PrefsPageSection[] prefsPageSectionArray = _sections;
        int n = _sections.length;
        int n2 = 0;
        while (n2 < n) {
            PrefsPageSection s = prefsPageSectionArray[n2];
            if (s != null) {
                this.sections.add(s);
            }
            ++n2;
        }
        this.validator = new CompositeValidator();
        for (PrefsPageSection s : this.sections) {
            this.validator.addChild((LiveExpression)s.getValidator());
        }
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    @Override
    public void createContents(Composite page) {
        final Group group = new Group(page, 0);
        group.setText(this.groupTitle);
        group.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        for (PrefsPageSection s : this.sections) {
            s.createContents((Composite)group);
        }
        this.isVisible.addListener(new ValueListener<Boolean>(){

            @Override
            public void gotValue(LiveExpression<Boolean> exp, Boolean isVisible) {
                group.setVisible(isVisible.booleanValue());
                GridData layout = (GridData)group.getLayoutData();
                layout.exclude = isVisible == false;
                group.setLayoutData((Object)layout);
                PrefsGroupSection.this.owner.getShell().layout(new Control[]{group});
            }
        });
    }

    @Override
    public boolean performOK() {
        for (PrefsPageSection s : this.sections) {
            if (s.performOK()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void performDefaults() {
        for (PrefsPageSection s : this.sections) {
            s.performDefaults();
        }
    }
}

