/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.metadata.MetadataUIImages;
import org.springframework.ide.eclipse.metadata.actions.Messages;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingMethodToClassMap;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingView;
import org.springframework.ide.eclipse.metadata.ui.RequestMappingViewLabelProvider;
import org.springframework.ide.eclipse.metadata.wizards.OpenRequestMappingUrlWizard;

public class OpenInBrowserAction
extends BaseSelectionListenerAction {
    private RequestMappingView viewPart;
    private RequestMappingViewLabelProvider labelProvider;
    private IBeansModelElement element;

    public OpenInBrowserAction(RequestMappingView viewPart, RequestMappingViewLabelProvider labelProvider) {
        super(Messages.OpenInBrowserAction_TITLE);
        this.setImageDescriptor(MetadataUIImages.DESC_OBJS_BROWSER);
        this.viewPart = viewPart;
        this.labelProvider = labelProvider;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.element = this.viewPart.getInput();
        if (this.getProject(this.element) == null) {
            return false;
        }
        Object obj = selection.getFirstElement();
        if (obj instanceof RequestMappingMethodToClassMap) {
            String methodType = this.labelProvider.getColumnText(obj, RequestMappingView.COLUMN_REQUEST_METHOD);
            return "RequestMethod.GET".equalsIgnoreCase(methodType);
        }
        return false;
    }

    public void run() {
        String url = this.labelProvider.getColumnText(this.getStructuredSelection().getFirstElement(), RequestMappingView.COLUMN_URL);
        if (url != null) {
            OpenRequestMappingUrlWizard wizard = new OpenRequestMappingUrlWizard((RequestMappingMethodToClassMap)this.getStructuredSelection().getFirstElement(), this.labelProvider, this.getProject(this.element));
            Shell shell = this.viewPart.getSite().getShell();
            if (shell != null) {
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.create();
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
        }
    }

    private IProject getProject(IBeansModelElement modelElement) {
        if (modelElement == null) {
            return null;
        }
        if (modelElement instanceof IBeansProject) {
            return ((IBeansProject)modelElement).getProject();
        }
        return ((IBeansProject)BeansModelUtils.getParentOfClass((IModelElement)modelElement, IBeansProject.class)).getProject();
    }
}

