/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.util;

import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.springframework.ide.eclipse.wizard.template.util.AbstractNameUrlPreferenceModel;
import org.springframework.ide.eclipse.wizard.template.util.AddEditNameUrlDialog;
import org.springframework.ide.eclipse.wizard.template.util.AddEditNameUrlDialogMessages;
import org.springframework.ide.eclipse.wizard.template.util.NameUrlContentProvider;
import org.springframework.ide.eclipse.wizard.template.util.NameUrlPair;
import org.springframework.ide.eclipse.wizard.template.util.NameUrlViewerSorter;

public abstract class AbstractNameUrlPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Table table;
    protected TableViewer tableViewer;
    List<NameUrlPair> elements;
    protected AbstractNameUrlPreferenceModel model;
    private Button editButton;
    private Button removeButton;
    private Button optionalCheckbox;

    protected abstract String preferencePageHeaderText();

    protected abstract AbstractNameUrlPreferenceModel getModel();

    protected abstract boolean shouldShowCheckbox();

    protected abstract String checkboxLabel();

    protected abstract String addDialogHeaderText();

    protected abstract AddEditNameUrlDialog getAddEditDialog(NameUrlPair var1);

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(this.doGetPreferenceStore());
        this.model = this.getModel();
    }

    public boolean performOk() {
        boolean okay = super.performOk();
        this.model.persist();
        return okay;
    }

    public boolean performCancel() {
        this.model.revert();
        return true;
    }

    private NameUrlPair getSelectedNameUrlPair() {
        StructuredSelection selectedTuple = (StructuredSelection)this.tableViewer.getSelection();
        NameUrlPair pair = (NameUrlPair)selectedTuple.getFirstElement();
        return pair;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(272);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        data = new GridData(256);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this.preferencePageHeaderText());
        this.table = new Table(composite, 68356);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)this.table);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new NameUrlContentProvider());
        this.tableViewer.setSorter((ViewerSorter)new NameUrlViewerSorter(true));
        TableViewerColumn nameColumn = new TableViewerColumn(this.tableViewer, 4);
        TableColumn swtNameColumn = nameColumn.getColumn();
        swtNameColumn.setText("name");
        swtNameColumn.setWidth(50);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NameUrlPair nameUrlPair = (NameUrlPair)element;
                return nameUrlPair.getName();
            }
        });
        nameColumn.getColumn().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNameUrlPreferencePage.this.tableViewer.setSorter((ViewerSorter)new NameUrlViewerSorter(true));
                AbstractNameUrlPreferencePage.this.removeButton.setEnabled(false);
                AbstractNameUrlPreferencePage.this.editButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        TableViewerColumn urlColumn = new TableViewerColumn(this.tableViewer, 4);
        urlColumn.getColumn().setText("URL");
        urlColumn.getColumn().setWidth(160);
        urlColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                NameUrlPair nameUrlPair = (NameUrlPair)element;
                return nameUrlPair.getUrlString();
            }
        });
        urlColumn.getColumn().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNameUrlPreferencePage.this.tableViewer.setSorter((ViewerSorter)new NameUrlViewerSorter(false));
                AbstractNameUrlPreferencePage.this.removeButton.setEnabled(false);
                AbstractNameUrlPreferencePage.this.editButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableViewer.setInput((Object)this.model);
        this.tableViewer.setColumnProperties(new String[]{"Name", "URL"});
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractNameUrlPreferencePage.this.removeButton.setEnabled(true);
                AbstractNameUrlPreferencePage.this.editButton.setEnabled(true);
            }
        });
        if (this.table.getItemCount() > 0) {
            TableColumn[] columns;
            TableColumn[] tableColumnArray = columns = this.table.getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
            this.table.pack();
        }
        Composite buttonComp = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, this.convertVerticalDLUsToPixels(3)).applyTo(buttonComp);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttonComp);
        Button addButton = new Button(buttonComp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addButton);
        addButton.setText(NLS.bind((String)"Add", null));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AddEditNameUrlDialog dialog = AbstractNameUrlPreferencePage.this.getAddEditDialog(null);
                if (dialog.open() == 0) {
                    String name;
                    String urlString = dialog.getUrlString().trim().replaceAll("\\n", "");
                    if (urlString.endsWith("/")) {
                        urlString = urlString.substring(0, urlString.length() - 1);
                    }
                    if ((name = dialog.getName()).length() > 0 && urlString.length() > 0) {
                        try {
                            AbstractNameUrlPreferencePage.this.model.addNameUrlPairInEncodedString(new NameUrlPair(name, urlString));
                            AbstractNameUrlPreferencePage.this.tableViewer.refresh();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            String message = NLS.bind((String)AddEditNameUrlDialogMessages.malformedUrlIgnoring, (Object)urlString);
                            MessageDialog.openError((Shell)AbstractNameUrlPreferencePage.this.getShell(), (String)AddEditNameUrlDialogMessages.malformedUrl, (String)message);
                        }
                    }
                }
            }
        });
        this.editButton = new Button(buttonComp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.editButton);
        this.editButton.setText(NLS.bind((String)"Edit", null));
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                NameUrlPair oldNameUrl = AbstractNameUrlPreferencePage.this.getSelectedNameUrlPair();
                AddEditNameUrlDialog dialog = AbstractNameUrlPreferencePage.this.getAddEditDialog(oldNameUrl);
                if (dialog.open() == 0) {
                    String name;
                    String urlString = dialog.getUrlString().trim().replaceAll("\\n", "");
                    if (urlString.endsWith("/")) {
                        urlString = urlString.substring(0, urlString.length() - 1);
                    }
                    if ((name = dialog.getName()).length() > 0 && urlString.length() > 0) {
                        try {
                            if (oldNameUrl != null) {
                                AbstractNameUrlPreferencePage.this.model.removeNameUrlPairInEncodedString(oldNameUrl);
                            }
                            AbstractNameUrlPreferencePage.this.model.addNameUrlPairInEncodedString(new NameUrlPair(name, urlString));
                            AbstractNameUrlPreferencePage.this.tableViewer.refresh();
                            AbstractNameUrlPreferencePage.this.editButton.setEnabled(false);
                            AbstractNameUrlPreferencePage.this.removeButton.setEnabled(false);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            String message = NLS.bind((String)AddEditNameUrlDialogMessages.malformedUrlIgnoring, (Object)urlString);
                            MessageDialog.openError((Shell)AbstractNameUrlPreferencePage.this.getShell(), (String)AddEditNameUrlDialogMessages.malformedUrl, (String)message);
                        }
                    }
                }
            }
        });
        this.removeButton = new Button(buttonComp, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.removeButton);
        this.removeButton.setText(NLS.bind((String)"Remove", null));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selectedTuple = (StructuredSelection)AbstractNameUrlPreferencePage.this.tableViewer.getSelection();
                NameUrlPair pair = (NameUrlPair)selectedTuple.getFirstElement();
                try {
                    NameUrlPair encodedPair = new NameUrlPair(pair.getName(), pair.getUrlString());
                    String title = NLS.bind((String)"Are you sure?", null);
                    String message = NLS.bind((String)"If you continue, {0} will be removed.  Are you sure you want to remove {0}?", (Object)pair.getName());
                    boolean answer = MessageDialog.openQuestion((Shell)AbstractNameUrlPreferencePage.this.getShell(), (String)title, (String)message);
                    if (answer) {
                        AbstractNameUrlPreferencePage.this.model.removeNameUrlPairInEncodedString(encodedPair);
                        AbstractNameUrlPreferencePage.this.tableViewer.remove((Object)selectedTuple);
                        AbstractNameUrlPreferencePage.this.tableViewer.refresh();
                        AbstractNameUrlPreferencePage.this.editButton.setEnabled(false);
                        AbstractNameUrlPreferencePage.this.removeButton.setEnabled(false);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    String errorTitle = NLS.bind((String)"Internal error", null);
                    String errorMessage = NLS.bind((String)"This error was not expected.  URL {0} was malformed when it was retrieved from the preferences properties", (Object)pair.getUrlString());
                    MessageDialog.openError((Shell)AbstractNameUrlPreferencePage.this.getShell(), (String)errorTitle, (String)errorMessage);
                }
            }
        });
        if (this.shouldShowCheckbox()) {
            this.optionalCheckbox = new Button(parent, 1120);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.optionalCheckbox);
            this.optionalCheckbox.setText(this.checkboxLabel());
            this.optionalCheckbox.setEnabled(true);
            this.optionalCheckbox.setSelection(this.model.getOptionalFlagValue());
            this.optionalCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractNameUrlPreferencePage.this.model.setOptionalFlagValue(AbstractNameUrlPreferencePage.this.optionalCheckbox.getSelection());
                }
            });
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void performDefaults() {
        this.model.clearNonDefaults();
        this.tableViewer.refresh();
    }

    protected void updateSelection(ISelection selection) {
    }

    protected boolean getCheckboxValue() {
        return this.optionalCheckbox.getSelection();
    }
}

