/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.template.SimpleProject;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateProjectData;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.TemplateProjectData;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;
import org.springsource.ide.eclipse.commons.content.core.ContentManager;
import org.springsource.ide.eclipse.commons.content.core.ContentPlugin;
import org.springsource.ide.eclipse.commons.content.core.TemplateDownloader;
import org.springsource.ide.eclipse.commons.ui.UiStatusHandler;

public class TemplateUtils {
    public static File importDirectory(ContentItem item, final Shell shell, boolean promptForDownload, SubMonitor monitor) throws CoreException, InterruptedException {
        Assert.isNotNull((Object)item);
        String id = item.getId();
        ContentManager manager = ContentPlugin.getDefault().getManager();
        if (item.needsDownload()) {
            final ContentItem finalItem = item;
            final boolean[] response = new boolean[]{true};
            if (promptForDownload) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        response[0] = TemplateUtils.promptForDownload(shell, finalItem);
                    }
                });
            }
            if (response[0]) {
                TemplateDownloader downloader = TemplateUtils.getTemplateDownloader(finalItem);
                IStatus status = downloader.downloadTemplate((IProgressMonitor)monitor);
                if (!status.isOK()) {
                    String message = NLS.bind((String)"Download of template ''{0}'' failed: {1}", (Object)id, (Object)status.getMessage());
                    throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", message));
                }
                item = manager.getItem(id);
                if (item == null) {
                    return null;
                }
            } else if (!item.isLocal()) {
                return null;
            }
        }
        File baseDir = manager.getInstallDirectory();
        if (item.isRuntimeDefined()) {
            File directory = new File(baseDir, item.getPath());
            String projectName = item.getLocalDescriptor().getUrl();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            File templateFolder = project.getLocation().toFile();
            TemplateUtils.copyFolder(templateFolder, directory);
        }
        if (!item.isLocal()) {
            String message = NLS.bind((String)"Download of template ''{0}'' failed", (Object)id);
            throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", message));
        }
        File projectDir = new File(baseDir, item.getPath());
        return projectDir;
    }

    public static boolean hasBeenDownloaded(Template template) {
        return template != null && template.getTemplateData() != null;
    }

    private static TemplateDownloader getTemplateDownloader(ContentItem item) {
        ContentManager manager = ContentPlugin.getDefault().getManager();
        return manager.createDownloader(item);
    }

    private static void copyFolder(File source, File destination) {
        File[] sourceFiles;
        File[] fileArray = sourceFiles = source.listFiles();
        int n = sourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block32: {
                File sourceFile = fileArray[n2];
                File destinationFile = new File(destination, sourceFile.getName());
                if (sourceFile.isDirectory()) {
                    TemplateUtils.copyFolder(sourceFile, destinationFile);
                } else {
                    FileOutputStream toStream;
                    block34: {
                        toStream = null;
                        FileInputStream fromStream = null;
                        try {
                            int bytesRead;
                            fromStream = new FileInputStream(sourceFile);
                            toStream = new FileOutputStream(destinationFile);
                            byte[] buffer = new byte[4096];
                            while ((bytesRead = fromStream.read(buffer)) != -1) {
                                toStream.write(buffer, 0, bytesRead);
                            }
                        }
                        catch (FileNotFoundException e) {
                            WizardPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "Failed to copy folder due to: " + e.getMessage(), (Throwable)e));
                            if (fromStream != null) {
                                try {
                                    fromStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (toStream != null) {
                                try {
                                    toStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block32;
                        }
                        catch (IOException e) {
                            block33: {
                                try {
                                    WizardPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", "I/O error when copying folder: " + e.getMessage(), (Throwable)e));
                                    if (fromStream == null) break block33;
                                }
                                catch (Throwable throwable) {
                                    if (fromStream != null) {
                                        try {
                                            fromStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (toStream != null) {
                                        try {
                                            toStream.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                try {
                                    fromStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (toStream != null) {
                                try {
                                    toStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block32;
                        }
                        if (fromStream == null) break block34;
                        try {
                            fromStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (toStream != null) {
                        try {
                            toStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++n2;
        }
    }

    public static ITemplateProjectData importTemplate(Template template, Shell shell, IProgressMonitor monitor) throws CoreException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean shouldPromptForDownload = !(template instanceof SimpleProject);
        File templateDir = TemplateUtils.importDirectory(template.getItem(), shell, shouldPromptForDownload, progress);
        if (templateDir == null) {
            return null;
        }
        if (!TemplateUtils.wasDownloadedViaDescriptor(templateDir)) {
            File[] childrenFiles = templateDir.listFiles();
            if (childrenFiles.length != 1) {
                String message = NLS.bind((String)"There are more files the template download directory {0} than expected; using first directory", (Object)templateDir);
                Status status = new Status(2, "org.springframework.ide.eclipse.wizard", message);
                UiStatusHandler.logAndDisplay((Shell)shell, (IStatus)status);
            }
            File subdir = null;
            File[] fileArray = childrenFiles;
            int n = childrenFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                if (childFile.isDirectory()) {
                    subdir = childFile;
                    break;
                }
                ++n2;
            }
            if (subdir != null) {
                File[] grandchildren;
                File[] fileArray2 = grandchildren = subdir.listFiles();
                int n3 = grandchildren.length;
                n = 0;
                while (n < n3) {
                    File grandchild = fileArray2[n];
                    grandchild.renameTo(new File(templateDir, grandchild.getName()));
                    ++n;
                }
                subdir.delete();
            } else {
                String message = NLS.bind((String)"There wasn't either {0} or a directory in the template download directory {1}", (Object)"template.xml", (Object)templateDir);
                Status status = new Status(2, "org.springframework.ide.eclipse.wizard", message);
                UiStatusHandler.logAndDisplay((Shell)shell, (IStatus)status);
            }
        }
        TemplateProjectData data = new TemplateProjectData(templateDir);
        data.read();
        progress.setWorkRemaining(10);
        return data;
    }

    private static boolean wasDownloadedViaDescriptor(File templateDir) {
        File templateXml = new File(templateDir, "template.xml");
        return templateXml.exists();
    }

    protected static boolean promptForDownload(Shell shell, ContentItem item) {
        if (CoreUtil.TEST_MODE) {
            return true;
        }
        try {
            List dependencies = ContentPlugin.getDefault().getManager().getDependencies(item);
            long size = 0L;
            for (ContentItem dependency : dependencies) {
                size += dependency.getDownloadSize();
            }
            String formattedSize = size > 0L ? NLS.bind((String)"{0} bytes", (Object)size) : NLS.bind((String)"unknown size", null);
            String requiredBundle = null;
            if (item.getLocalDescriptor() != null) {
                requiredBundle = item.getLocalDescriptor().getRequiresBundle();
            } else if (item.getRemoteDescriptor() != null) {
                requiredBundle = item.getRemoteDescriptor().getRequiresBundle();
            }
            String message = requiredBundle != null && !TemplateUtils.hasBundle(requiredBundle) ? NLS.bind((String)"Warning: this project requires the bundle \n\t{0}\nwhich is not installed.  You can download this template, but it will probably get build errors.\n\n", (Object)requiredBundle) : "";
            if (!item.isLocal()) {
                message = String.valueOf(message) + NLS.bind((String)"{0} requires a download of {1}.\n\nProceed?", (Object)item.getName(), (Object)formattedSize);
                return MessageDialog.openQuestion((Shell)shell, (String)"Import", (String)message);
            }
            if (item.isNewerVersionAvailable()) {
                message = NLS.bind((String)("An update for {0} is available which requires a download of {1}.\n\n" + message + "Update?"), (Object)item.getName(), (Object)formattedSize);
                return MessageDialog.openQuestion((Shell)shell, (String)"Import", (String)message);
            }
        }
        catch (CoreException e) {
            UiStatusHandler.logAndDisplay((Shell)shell, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private static boolean hasBundle(String requiredBundle) {
        return Platform.getBundle((String)requiredBundle) != null;
    }
}

