/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml;

import java.util.HashSet;
import java.util.Set;
import org.dadacoalition.yedit.editor.YEditSourceViewerConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.ICompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.IPropertyHoverInfoProvider;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesHyperlinkDetector;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesProposalProcessor;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesReconciler;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesReconcilerFactory;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesTextHover;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.IReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.util.DocumentUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.HyperlinkDetectorUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtilProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.YamlEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.YamlHoverInfoProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.YamlASTProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.completions.YamlCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.SpringYamlReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.structure.YamlStructureProvider;
import org.yaml.snakeyaml.Yaml;

public class SpringYeditSourceViewerConfiguration
extends YEditSourceViewerConfiguration {
    private static final String DIALOG_SETTINGS_KEY = SpringYeditSourceViewerConfiguration.class.getName();
    private static final DocumentContextFinder documentContextFinder = DocumentContextFinder.DEFAULT;
    private static final Set<String> ANNOTIONS_SHOWN_IN_TEXT = new HashSet<String>();
    private static final Set<String> ANNOTIONS_SHOWN_IN_OVERVIEW_BAR;
    private Yaml yaml = new Yaml();
    private YamlASTProvider astProvider = new YamlASTProvider(this.yaml);
    private SpringPropertyIndexProvider indexProvider = new SpringPropertyIndexProvider(){

        public FuzzyMap<PropertyInfo> getIndex(IDocument doc) {
            IJavaProject jp = DocumentUtil.getJavaProject((IDocument)doc);
            if (jp != null) {
                return SpringPropertiesEditorPlugin.getIndexManager().get(jp);
            }
            return null;
        }
    };
    private TypeUtilProvider typeUtilProvider = new TypeUtilProvider(){

        public TypeUtil getTypeUtil(IDocument doc) {
            return new TypeUtil(DocumentUtil.getJavaProject((IDocument)doc));
        }
    };
    private IPropertyHoverInfoProvider hoverProvider = new YamlHoverInfoProvider(this.astProvider, this.indexProvider, documentContextFinder);
    private SpringPropertiesReconciler fReconciler;
    private SpringPropertiesReconcilerFactory fReconcilerFactory = new SpringPropertiesReconcilerFactory(){

        protected IReconcileEngine createEngine() throws Exception {
            return new SpringYamlReconcileEngine(SpringYeditSourceViewerConfiguration.this.astProvider, SpringYeditSourceViewerConfiguration.this.indexProvider, SpringYeditSourceViewerConfiguration.this.typeUtilProvider);
        }
    };
    private YamlStructureProvider structureProvider = YamlStructureProvider.DEFAULT;
    private ICompletionEngine completionEngine = new YamlCompletionEngine(this.yaml, this.indexProvider, documentContextFinder, this.structureProvider, this.typeUtilProvider);

    static {
        ANNOTIONS_SHOWN_IN_TEXT.add("org.eclipse.jdt.ui.warning");
        ANNOTIONS_SHOWN_IN_TEXT.add("org.eclipse.jdt.ui.error");
        ANNOTIONS_SHOWN_IN_OVERVIEW_BAR = ANNOTIONS_SHOWN_IN_TEXT;
    }

    public static void debug(String string) {
        System.out.println(string);
    }

    private IDialogSettings getDialogSettings(ISourceViewer sourceViewer, String dialogSettingsKey) {
        IDialogSettings existing = YamlEditorPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (existing != null) {
            return existing;
        }
        IDialogSettings created = SpringPropertiesEditorPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        Rectangle windowBounds = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getBounds();
        int suggestW = (int)((double)windowBounds.width * 0.35);
        int suggestH = (int)((double)suggestW * 0.6);
        if (suggestW > 300) {
            created.put("size.x", suggestW);
            created.put("size.y", suggestH);
        }
        return created;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 0);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (contentType.equals("__dftl_partition_content_type") && 255 == stateMask) {
            Object delegate = super.getTextHover(sourceViewer, contentType, stateMask);
            if (delegate == null) {
                delegate = new DefaultTextHover(sourceViewer){

                    protected boolean isIncluded(Annotation annotation) {
                        return ANNOTIONS_SHOWN_IN_TEXT.contains(annotation.getType());
                    }
                };
            }
            try {
                return new SpringPropertiesTextHover(sourceViewer, this.hoverProvider, delegate);
            }
            catch (Exception e) {
                SpringPropertiesEditorPlugin.log((Throwable)e);
                return delegate;
            }
        }
        return super.getTextHover(sourceViewer, contentType, stateMask);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return ANNOTIONS_SHOWN_IN_OVERVIEW_BAR.contains(annotation.getType());
            }
        };
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fReconciler == null) {
            this.fReconciler = this.fReconcilerFactory.createReconciler(sourceViewer);
        }
        return this.fReconciler;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        SpringPropertiesHyperlinkDetector myDetector = null;
        try {
            myDetector = new SpringPropertiesHyperlinkDetector(this.hoverProvider);
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log((Throwable)e);
        }
        return HyperlinkDetectorUtil.merge((IHyperlinkDetector[])super.getHyperlinkDetectors(sourceViewer), (IHyperlinkDetector)myDetector);
    }

    public IContentAssistant getContentAssistant(ISourceViewer viewer) {
        IContentAssistant _a = super.getContentAssistant(viewer);
        if (_a instanceof ContentAssistant) {
            ContentAssistant a = (ContentAssistant)_a;
            a.setInformationControlCreator(this.getInformationControlCreator(viewer));
            a.enableColoredLabels(true);
            a.enablePrefixCompletion(false);
            a.enableAutoInsert(true);
            a.enableAutoActivation(true);
            a.setRestoreCompletionProposalSize(this.getDialogSettings(viewer, DIALOG_SETTINGS_KEY));
            SpringPropertiesProposalProcessor processor = new SpringPropertiesProposalProcessor(this.completionEngine);
            a.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
            a.setSorter(PropertyCompletionFactory.SORTER);
        }
        return _a;
    }

    public void forceReconcile() {
        if (this.fReconciler != null) {
            this.fReconciler.forceReconcile();
        }
    }
}

