/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.typehierarchy;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyClassReader;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyClassReaderFactory;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyElement;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyElementCache;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyElementCacheFactory;

public class TypeHierarchyEngine {
    public static final String ENABLE_PROPERTY = "org.springframework.ide.eclipse.core.java.enableTypeHierarchyEngine";
    private TypeHierarchyClassReaderFactory classReaderFactory;
    private TypeHierarchyElementCacheFactory elementCacheFactory;
    private final Map<IProject, TypeHierarchyElementCache> cache;
    private final Map<IProject, TypeHierarchyClassReader> readers;
    private final boolean autoCleanup;

    public TypeHierarchyEngine(boolean autoCleanup) {
        this.autoCleanup = autoCleanup;
        this.cache = new ConcurrentHashMap<IProject, TypeHierarchyElementCache>();
        this.readers = new ConcurrentHashMap<IProject, TypeHierarchyClassReader>();
    }

    public void setClassReaderFactory(TypeHierarchyClassReaderFactory classReaderFactory) {
        this.classReaderFactory = classReaderFactory;
    }

    public void setTypeHierarchyElementCacheFactory(TypeHierarchyElementCacheFactory elementCacheFactory) {
        this.elementCacheFactory = elementCacheFactory;
    }

    public void cleanup(IProject project) {
        TypeHierarchyClassReader reader = this.readers.get(project);
        if (reader != null) {
            reader.cleanup();
        }
    }

    public void cleanup() {
        for (IProject project : this.readers.keySet()) {
            this.cleanup(project);
        }
    }

    public void clearCache(IProject project) {
        this.cleanup(project);
        this.readers.remove(project);
        this.cache.remove(project);
    }

    public void clearCache() {
        for (IProject project : this.readers.keySet()) {
            this.clearCache(project);
        }
    }

    public String getSupertype(IType type) {
        IJavaElement ancestor = type.getAncestor(2);
        if (ancestor != null && ancestor instanceof IJavaProject) {
            IProject project = ((IJavaProject)ancestor).getProject();
            return this.getSupertype(project, type.getFullyQualifiedName());
        }
        return null;
    }

    public String getSupertype(IProject project, String className) {
        char[] typeName = className.replace('.', '/').toCharArray();
        try {
            TypeHierarchyElementCache elementCache = this.getTypeHierarchyElementCache(project);
            TypeHierarchyElement typeElement = this.getTypeElement(typeName, project, elementCache);
            if (typeElement != null && typeElement.superclassName != null) {
                String string = new String(typeElement.superclassName).replace("/", ".");
                return string;
            }
        }
        finally {
            if (this.autoCleanup) {
                this.cleanup(project);
            }
        }
        return null;
    }

    public String[] getInterfaces(IProject project, String className) {
        char[] typeName = className.replace('.', '/').toCharArray();
        try {
            TypeHierarchyElementCache elementCache = this.getTypeHierarchyElementCache(project);
            TypeHierarchyElement typeElement = this.getTypeElement(typeName, project, elementCache);
            if (typeElement != null && typeElement.interfaces != null) {
                String[] result = new String[typeElement.interfaces.length];
                int i = 0;
                while (i < result.length) {
                    result[i] = new String(typeElement.interfaces[i]).replace("/", ".");
                    ++i;
                }
                String[] stringArray = result;
                return stringArray;
            }
        }
        finally {
            if (this.autoCleanup) {
                this.cleanup(project);
            }
        }
        return null;
    }

    public boolean doesExtend(IType type, String className) {
        IJavaElement ancestor = type.getAncestor(2);
        if (ancestor != null && ancestor instanceof IJavaProject) {
            IProject project = ((IJavaProject)ancestor).getProject();
            return this.doesExtend(type.getFullyQualifiedName(), className, project);
        }
        return false;
    }

    public boolean doesExtend(String type, String className, IProject project) {
        char[] typeName = type.replace('.', '/').toCharArray();
        char[] superTypeName = className.replace('.', '/').toCharArray();
        TypeHierarchyElementCache elementCache = this.getTypeHierarchyElementCache(project);
        try {
            TypeHierarchyElement typeElement = null;
            TypeHierarchyElement previousTypeElement = null;
            return (boolean)previousTypeElement;
        }
        finally {
            if (this.autoCleanup) {
                this.cleanup(project);
            }
        }
    }

    public boolean doesImplement(IType type, String interfaceName) {
        IJavaElement ancestor = type.getAncestor(2);
        if (ancestor != null && ancestor instanceof IJavaProject) {
            IProject project = ((IJavaProject)ancestor).getProject();
            return this.doesImplement(type.getFullyQualifiedName(), interfaceName, project);
        }
        return false;
    }

    public boolean doesImplement(String type, String interfaceName, IProject project) {
        char[] classTypeName = type.replace('.', '/').toCharArray();
        char[] interfaceTypeName = interfaceName.replace('.', '/').toCharArray();
        try {
            boolean result;
            TypeHierarchyElementCache elementCache = this.getTypeHierarchyElementCache(project);
            boolean bl = result = this.doesImplement(project, classTypeName, interfaceTypeName, true, elementCache) || this.doesImplement(project, classTypeName, interfaceTypeName, false, elementCache);
            return bl;
        }
        finally {
            if (this.autoCleanup) {
                this.cleanup(project);
            }
        }
    }

    protected boolean doesImplement(IProject project, char[] classTypeName, char[] interfaceTypeName, boolean cachedItemsOnly, TypeHierarchyElementCache elementCache) {
        TypeHierarchyElement classTypeElement = this.getTypeElement(classTypeName, project, elementCache);
        do {
            if (classTypeElement != null) {
                if (classTypeElement.interfaces != null) {
                    ArrayDeque<TypeHierarchyElement> elementStack = new ArrayDeque<TypeHierarchyElement>();
                    elementStack.add(classTypeElement);
                    while (!elementStack.isEmpty()) {
                        TypeHierarchyElement element = (TypeHierarchyElement)elementStack.pop();
                        char[][] cArray = element.interfaces;
                        int n = element.interfaces.length;
                        int n2 = 0;
                        while (n2 < n) {
                            char[] interfaceToAnalyze = cArray[n2];
                            if (CharOperation.equals((char[])interfaceToAnalyze, (char[])interfaceTypeName)) {
                                return true;
                            }
                            ++n2;
                        }
                        int i = 0;
                        while (i < element.interfaces.length) {
                            char[] interfaceToAnalyze = element.interfaces[i];
                            TypeHierarchyElement interfaceToAnalyzeElement = element.interfacesElements[i];
                            if (!cachedItemsOnly || interfaceToAnalyzeElement != null || elementCache.get(interfaceToAnalyze) != null) {
                                if (interfaceToAnalyzeElement == null) {
                                    element.interfacesElements[i] = interfaceToAnalyzeElement = this.getTypeElement(interfaceToAnalyze, project, elementCache);
                                }
                                if (interfaceToAnalyzeElement != null && interfaceToAnalyzeElement.interfaces != null) {
                                    elementStack.add(interfaceToAnalyzeElement);
                                }
                            }
                            ++i;
                        }
                    }
                }
                classTypeName = classTypeElement.superclassName;
                TypeHierarchyElement superClassTypeElement = classTypeElement.superclassElement;
                if (!(superClassTypeElement != null || classTypeName == null || cachedItemsOnly && elementCache.get(classTypeName) == null)) {
                    classTypeElement.superclassElement = superClassTypeElement = this.getTypeElement(classTypeName, project, elementCache);
                }
                classTypeElement = superClassTypeElement;
                if (!cachedItemsOnly || classTypeName == null || classTypeElement != null || elementCache.get(classTypeName) != null) continue;
                classTypeName = null;
                continue;
            }
            classTypeName = null;
        } while (classTypeName != null);
        return false;
    }

    private TypeHierarchyElement getTypeElement(char[] fullyQualifiedClassName, IProject project, TypeHierarchyElementCache elementCache) {
        TypeHierarchyElement result = elementCache.get(fullyQualifiedClassName);
        if (result == null && (result = this.getClassReader(project).readTypeHierarchyInformation(fullyQualifiedClassName, project)) != null) {
            elementCache.put(fullyQualifiedClassName, result);
        }
        return result;
    }

    protected TypeHierarchyElementCache getTypeHierarchyElementCache(IProject project) {
        TypeHierarchyElementCache elementCache = this.cache.get(project);
        if (elementCache == null) {
            elementCache = this.elementCacheFactory.createTypeHierarchyElementCache();
            this.cache.put(project, elementCache);
        }
        return elementCache;
    }

    private TypeHierarchyClassReader getClassReader(IProject project) {
        TypeHierarchyClassReader result = this.readers.get(project);
        if (result == null) {
            result = this.classReaderFactory.createClassReader(project);
            this.readers.put(project, result);
        }
        return result;
    }
}

