/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.ClassContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class FieldContentAssistCalculator
extends ClassContentAssistCalculator {
    private final JavaElementImageProvider imageProvider = new JavaElementImageProvider();

    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        String matchString = context.getMatchString();
        int ix = matchString.lastIndexOf(46);
        if (ix > 0) {
            IType type;
            String typeName = matchString.substring(0, ix);
            IFile file = context.getFile();
            if (file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)typeName)) != null) {
                try {
                    IField[] fields;
                    IField[] iFieldArray = fields = type.getFields();
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IField field = iFieldArray[n2];
                        if (Flags.isStatic((int)field.getFlags()) && Flags.isPublic((int)field.getFlags())) {
                            this.acceptSearchMatch(recorder, field, typeName);
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return;
            }
        }
        super.computeProposals(context, recorder);
    }

    private void acceptSearchMatch(IContentAssistProposalRecorder recorder, IField field, String typeName) {
        try {
            String replaceText = String.valueOf(typeName) + "." + field.getElementName();
            String displayText = field.getElementName();
            Image image = this.imageProvider.getImageLabel((Object)field, field.getFlags() | 2);
            recorder.recordProposal(image, 10, displayText, replaceText, field);
        }
        catch (JavaModelException javaModelException) {}
    }
}

