/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo;

import com.atlassian.theplugin.commons.bamboo.BambooChangeSet;
import com.atlassian.theplugin.commons.bamboo.BambooChangeSetImpl;
import com.atlassian.theplugin.commons.bamboo.BambooJob;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.TestDetails;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDetailsInfo
implements BuildDetails {
    private String vcsRevisionKey;
    private List<TestDetails> successfulTests = new ArrayList<TestDetails>();
    private List<TestDetails> failedTests = new ArrayList<TestDetails>();
    private List<BambooChangeSet> commitInfo;
    private final List<BambooJob> jobs = new ArrayList<BambooJob>();

    public BuildDetailsInfo() {
        this.commitInfo = new ArrayList<BambooChangeSet>();
    }

    @Override
    public String getVcsRevisionKey() {
        return this.vcsRevisionKey;
    }

    public void setVcsRevisionKey(String vcsRevisionKey) {
        this.vcsRevisionKey = vcsRevisionKey;
    }

    @Override
    public List<TestDetails> getSuccessfulTestDetails() {
        return this.successfulTests;
    }

    public void setSuccessfulTests(List<TestDetails> successfulTests) {
        this.successfulTests = successfulTests;
    }

    public void addSuccessfulTest(TestDetails test) {
        this.successfulTests.add(test);
    }

    @Override
    public List<TestDetails> getFailedTestDetails() {
        return this.failedTests;
    }

    public void setFailedTests(List<TestDetails> failedTests) {
        this.failedTests = failedTests;
    }

    public void addFailedTest(TestDetails test) {
        this.failedTests.add(test);
    }

    @Override
    public List<BambooChangeSet> getCommitInfo() {
        return this.commitInfo;
    }

    public void setCommitInfo(List<BambooChangeSet> commitInfo) {
        this.commitInfo = commitInfo;
    }

    public void addCommitInfo(BambooChangeSetImpl commit) {
        this.commitInfo.add(commit);
    }

    public void addJob(BambooJob job) {
        this.jobs.add(job);
    }

    @Override
    public List<BambooJob> getJobs() {
        return this.jobs;
    }

    @Override
    public List<BambooJob> getEnabledJobs() {
        ArrayList<BambooJob> enabledJobs = MiscUtil.buildArrayList();
        for (BambooJob job : this.jobs) {
            if (!job.isEnabled()) continue;
            enabledJobs.add(job);
        }
        return enabledJobs;
    }
}

