/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import org.eclipse.core.resources.IProject;
import org.springframework.ide.eclipse.boot.launch.EnableDebugLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.IProfileHistory;
import org.springframework.ide.eclipse.boot.launch.LaunchTabSelectionModel;
import org.springframework.ide.eclipse.boot.launch.MainTypeNameLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.ProfileLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.SelectProjectLaunchTabModel;
import org.springframework.ide.eclipse.boot.launch.livebean.EnableJmxFeaturesModel;
import org.springframework.ide.eclipse.boot.util.StringUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public class BootLaunchUIModel {
    public final SelectProjectLaunchTabModel project = SelectProjectLaunchTabModel.create();
    public final MainTypeNameLaunchTabModel mainTypeName = MainTypeNameLaunchTabModel.create();
    public final ProfileLaunchTabModel profile;
    public final LaunchTabSelectionModel<Boolean> enableDebug;
    public final EnableJmxFeaturesModel enableJmx;

    public BootLaunchUIModel(IProfileHistory profileHistory) {
        this.profile = ProfileLaunchTabModel.create((LiveExpression<IProject>)this.project.selection, profileHistory);
        this.enableDebug = EnableDebugLaunchTabModel.create();
        this.enableJmx = new EnableJmxFeaturesModel();
    }

    public static class MainTypeValidator
    extends Validator {
        private LiveVariable<String> mainTypeName;

        public MainTypeValidator(LiveVariable<String> n) {
            this.mainTypeName = n;
            this.dependsOn((LiveExpression)this.mainTypeName);
        }

        protected ValidationResult compute() {
            String name = (String)this.mainTypeName.getValue();
            if (!StringUtil.hasText((String)name)) {
                return ValidationResult.error((String)"No Main type selected");
            }
            return ValidationResult.OK;
        }
    }
}

