/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.internal.validation;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.internal.model.SpringProject;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidator;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationElementLifecycleManager;
import org.springframework.ide.eclipse.data.internal.validation.CompilationUnit;
import org.springframework.ide.eclipse.data.internal.validation.SpringDataValidationContext;

public class SpringDataValidator
extends AbstractValidator {
    public Set<IResource> deriveResources(Object object) {
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        if (object instanceof ISpringProject) {
            resources.add((IResource)((ISpringProject)object).getProject());
        }
        return resources;
    }

    public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        if (resource instanceof IFile && resource.getName().endsWith(".java") && JavaCore.create((IFile)((IFile)resource)) != null) {
            return Collections.singleton(resource);
        }
        return Collections.emptySet();
    }

    protected IValidationContext createContext(IResourceModelElement rootElement, IResourceModelElement contextElement) {
        return new SpringDataValidationContext(rootElement, contextElement);
    }

    protected IValidationElementLifecycleManager createValidationElementLifecycleManager() {
        return new SpringValidationElementLifecycleManager();
    }

    protected boolean supports(IModelElement element) {
        return element instanceof CompilationUnit;
    }

    private static class SpringValidationElementLifecycleManager
    implements IValidationElementLifecycleManager {
        private IResourceModelElement rootElement;

        private SpringValidationElementLifecycleManager() {
        }

        public void destroy() {
        }

        public Set<IResourceModelElement> getContextElements() {
            LinkedHashSet<IResourceModelElement> resources = new LinkedHashSet<IResourceModelElement>();
            resources.add(this.getRootElement());
            return resources;
        }

        public IResourceModelElement getRootElement() {
            return this.rootElement;
        }

        public void init(IResource resource) {
            ICompilationUnit cu = this.getCompilationUnit(resource);
            SpringProject parent = new SpringProject(SpringCore.getModel(), resource.getProject());
            String name = resource.getName();
            this.rootElement = new CompilationUnit(cu, (IModelElement)parent, name);
        }

        private ICompilationUnit getCompilationUnit(IResource resource) {
            IJavaProject project = this.getJavaProject(resource);
            if (project == null) {
                return null;
            }
            if (resource.getType() == 1) {
                return (ICompilationUnit)JavaCore.create((IFile)((IFile)resource));
            }
            return null;
        }

        private IJavaProject getJavaProject(IResource resource) {
            IProject project = resource.getProject();
            return JavaCore.create((IProject)project);
        }
    }
}

