/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class SimpleActivityLabel
extends Label {
    private boolean selected;
    private boolean hasFocus;

    public SimpleActivityLabel(int direction) {
        this.setLabelAlignment(1);
        if (direction == 16) {
            this.setTextPlacement(4);
        }
    }

    private Rectangle getSelectionRectangle() {
        Rectangle bounds = this.getTextBounds();
        bounds.expand(new Insets(2, 2, 0, 0));
        this.translateToParent((Translatable)bounds);
        bounds.intersect(this.getBounds());
        return bounds;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.selected) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        if (this.hasFocus) {
            graphics.pushState();
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.menuBackgroundSelected);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.drawFocus(this.getSelectionRectangle().resize(-1, -1));
            graphics.popState();
        }
        super.paintFigure(graphics);
    }

    public void setFocus(boolean b) {
        this.hasFocus = b;
        this.repaint();
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.repaint();
    }
}

