/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.springframework.ide.eclipse.config.graph.figures.ConnectorBorder;
import org.springframework.ide.eclipse.config.graph.figures.SimpleActivityLabel;
import org.springframework.ide.eclipse.config.graph.parts.FixedConnectionAnchor;

public class BorderedActivityLabel
extends SimpleActivityLabel {
    protected final int direction;
    protected final List<String> inputs;
    protected final List<String> outputs;
    protected Hashtable<String, FixedConnectionAnchor> connectionAnchors = new Hashtable();
    protected Vector<FixedConnectionAnchor> inputConnectionAnchors = new Vector();
    protected Vector<FixedConnectionAnchor> outputConnectionAnchors = new Vector();
    protected ConnectorBorder border;

    public BorderedActivityLabel(int direction, List<String> inputs, List<String> outputs) {
        super(direction);
        this.direction = direction;
        this.inputs = inputs;
        this.outputs = outputs;
        this.border = this.createConnectorBorder();
        this.setBorder((Border)this.border);
        this.createConnectionAnchors();
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        int gap = this.getIconTextGap();
        Dimension d = new Dimension(0, 0);
        if (this.getTextPlacement() == 8 || this.getTextPlacement() == 16) {
            d.width = this.getIconSize().width + gap + txtSize.width;
            d.height = Math.max(this.getIconSize().height, txtSize.height);
        } else {
            d.width = Math.max(this.getIconSize().width, txtSize.width);
            d.height = this.getIconSize().height + gap + txtSize.height;
        }
        return d;
    }

    public ConnectionAnchor connectionAnchorAt(Point p) {
        long d;
        Point p2;
        ConnectionAnchor c;
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration<FixedConnectionAnchor> e = this.getSourceConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            c = (ConnectionAnchor)e.nextElement();
            p2 = c.getLocation(null);
            d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        e = this.getTargetConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            c = (ConnectionAnchor)e.nextElement();
            p2 = c.getLocation(null);
            d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    protected void createConnectionAnchors() {
        int i = 0;
        while (i < this.inputs.size()) {
            FixedConnectionAnchor in = new FixedConnectionAnchor((IFigure)this, this.inputs.get(i));
            this.connectionAnchors.put(in.getConnectionLabel(), in);
            this.inputConnectionAnchors.addElement(in);
            ++i;
        }
        i = 0;
        while (i < this.outputs.size()) {
            FixedConnectionAnchor out = new FixedConnectionAnchor((IFigure)this, this.outputs.get(i));
            this.connectionAnchors.put(out.getConnectionLabel(), out);
            this.outputConnectionAnchors.addElement(out);
            ++i;
        }
    }

    protected ConnectorBorder createConnectorBorder() {
        return new ConnectorBorder(this.direction, this.inputs.size(), this.outputs.size());
    }

    public ConnectionAnchor getConnectionAnchor(String terminal) {
        return (ConnectionAnchor)this.connectionAnchors.get(terminal);
    }

    public ConnectionAnchor getConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Collection<FixedConnectionAnchor> coll = this.connectionAnchors.values();
        for (ConnectionAnchor connectionAnchor : coll) {
            Point p2 = connectionAnchor.getLocation(null);
            long d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = connectionAnchor;
        }
        return closest;
    }

    public String getConnectionAnchorName(ConnectionAnchor c) {
        Enumeration<String> keys = this.connectionAnchors.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!this.connectionAnchors.get(key).equals(c)) continue;
            return key;
        }
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration<FixedConnectionAnchor> e = this.getSourceConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = (ConnectionAnchor)e.nextElement();
            Point p2 = c.getLocation(null);
            long d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public Vector<FixedConnectionAnchor> getSourceConnectionAnchors() {
        return this.outputConnectionAnchors;
    }

    public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
        ConnectionAnchor closest = null;
        long min = Long.MAX_VALUE;
        Enumeration<FixedConnectionAnchor> e = this.getTargetConnectionAnchors().elements();
        while (e.hasMoreElements()) {
            ConnectionAnchor c = (ConnectionAnchor)e.nextElement();
            Point p2 = c.getLocation(null);
            long d = p.getDistance2(p2);
            if (d >= min) continue;
            min = d;
            closest = c;
        }
        return closest;
    }

    public Vector<FixedConnectionAnchor> getTargetConnectionAnchors() {
        return this.inputConnectionAnchors;
    }

    protected void layoutConnectionAnchors() {
        Rectangle rect = this.getBounds();
        int inputCapacity = this.inputs.size();
        int outputCapacity = this.outputs.size();
        if (this.direction == 16) {
            int height = rect.height;
            int i = 0;
            while (i < inputCapacity) {
                FixedConnectionAnchor in = (FixedConnectionAnchor)this.getConnectionAnchor(this.inputs.get(i));
                in.offsetV = (2 * i + 1) * height / (inputCapacity * 2);
                ++i;
            }
            i = 0;
            while (i < outputCapacity) {
                FixedConnectionAnchor out = (FixedConnectionAnchor)this.getConnectionAnchor(this.outputs.get(i));
                out.offsetV = (2 * i + 1) * height / (outputCapacity * 2);
                out.leftToRight = false;
                ++i;
            }
        } else {
            int width = rect.width;
            int i = 0;
            while (i < inputCapacity) {
                FixedConnectionAnchor in = (FixedConnectionAnchor)this.getConnectionAnchor(this.inputs.get(i));
                in.offsetH = (2 * i + 1) * width / (inputCapacity * 2);
                ++i;
            }
            i = 0;
            while (i < outputCapacity) {
                FixedConnectionAnchor out = (FixedConnectionAnchor)this.getConnectionAnchor(this.outputs.get(i));
                out.offsetH = (2 * i + 1) * width / (outputCapacity * 2);
                out.topDown = false;
                ++i;
            }
        }
    }

    public void setBorderLabel(String label) {
        if (this.border != null) {
            this.border.setLabel(label);
        }
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.layoutConnectionAnchors();
        super.validate();
    }
}

