/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.core;

import com.atlassian.connector.eclipse.internal.bamboo.core.SaxTestResultsWriter;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.TestDetails;
import com.atlassian.theplugin.commons.bamboo.TestResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultExternalizer {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_CLASS_NAME = "classname";
    public static final String ATTRIBUTE_PROJECT = "project";
    public static final String ATTRIBUTE_TESTS = "tests";
    public static final String ATTRIBUTE_STARTED = "started";
    public static final String ATTRIBUTE_FAILURES = "failures";
    public static final String ATTRIBUTE_ERRORS = "errors";
    public static final String ATTRIBUTE_IGNORED = "ignored";
    public static final String ATTRIBUTE_TIME = "time";
    public static final String ELEMENT_TESTRUN = "testrun";
    public static final String ELEMENT_TESTSUITE = "testsuite";
    public static final String ELEMENT_TESTCASE = "testcase";
    public static final String ELEMENT_FAILURE = "failure";
    private final SaxTestResultsWriter writer = new SaxTestResultsWriter();

    public File writeApplicationsToXML(BambooBuild build, BuildDetails buildDetails, File file) throws CoreException {
        Map<String, TestSuite> testResults = this.prepareTestResults(build, buildDetails);
        int failed = buildDetails.getFailedTestDetails().size();
        int success = buildDetails.getSuccessfulTestDetails().size();
        if (testResults == null) {
            return null;
        }
        OutputStream stream = null;
        try {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                stream = new FileOutputStream(file);
                this.writer.setOutputStream(stream);
                this.writer.writeApplicationsToStream(testResults, build, failed, success);
                stream.flush();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.core", "Could not write: " + file.getAbsolutePath(), (Throwable)e));
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.bamboo.core", "Unable to terminate output stream to applications file.", (Throwable)e));
                }
            }
        }
        return file;
    }

    private Map<String, TestSuite> prepareTestResults(BambooBuild build, BuildDetails buildDetails) {
        TestSuite suite;
        HashMap<String, TestSuite> testSuites = new HashMap<String, TestSuite>();
        for (TestDetails test : buildDetails.getSuccessfulTestDetails()) {
            suite = (TestSuite)testSuites.get(test.getTestClassName());
            if (suite == null) {
                suite = new TestSuite(test.getTestClassName());
                testSuites.put(test.getTestClassName(), suite);
            }
            suite.addTest(test);
        }
        for (TestDetails test : buildDetails.getFailedTestDetails()) {
            suite = (TestSuite)testSuites.get(test.getTestClassName());
            if (suite == null) {
                suite = new TestSuite(test.getTestClassName());
                testSuites.put(test.getTestClassName(), suite);
            }
            suite.addTest(test);
        }
        return testSuites;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TestSuite {
        private final String className;
        private double totalDuration;
        private int totalTests;
        private int totalFailed;
        private int totalSucceeded;
        private final Set<TestDetails> tests;

        public TestSuite(String className) {
            this.className = className;
            this.tests = new LinkedHashSet<TestDetails>();
        }

        public void addTest(TestDetails test) {
            this.tests.add(test);
            this.totalDuration += test.getTestDuration();
            ++this.totalTests;
            if (test.getTestResult() == TestResult.TEST_SUCCEED) {
                ++this.totalSucceeded;
            } else {
                ++this.totalFailed;
            }
        }

        public double getTotalDuration() {
            return this.totalDuration;
        }

        public int getTotalTests() {
            return this.totalTests;
        }

        public int getFailedTests() {
            return this.totalFailed;
        }

        public int getSucceededTests() {
            return this.totalSucceeded;
        }

        public String getClassName() {
            return this.className;
        }

        public Set<TestDetails> getTests() {
            return this.tests;
        }
    }
}

