/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.Comment;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ASTContentProvider
implements ITreeContentProvider {
    private boolean includeImports;
    private boolean includeComments;
    private static final Comparator<Node> ByLineNumber = new Comparator<Node>(){

        @Override
        public int compare(Node a, Node b) {
            return a.getBeginLine() - b.getBeginLine();
        }
    };

    public void includeImports(boolean flag) {
        this.includeImports = flag;
    }

    public void includeComments(boolean flag) {
        this.includeComments = flag;
    }

    public ASTContentProvider(boolean includeImportsFlag, boolean includeCommentsFlag) {
        this(Collections.EMPTY_SET);
        this.includeImports = includeImportsFlag;
        this.includeComments = includeCommentsFlag;
    }

    public ASTContentProvider(Set<Class<?>> theHiddenNodeTypes) {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private List<Node> withoutHiddenOnes(Object parent) {
        ArrayList<Node> kids = new ArrayList<Node>();
        if (this.includeComments && parent instanceof ASTCompilationUnit) {
            List comments = ((ASTCompilationUnit)parent).getComments();
            kids.addAll(comments);
        }
        AbstractNode node = (AbstractNode)parent;
        int kidCount = node.jjtGetNumChildren();
        int i = 0;
        while (i < kidCount) {
            Node kid = node.jjtGetChild(i);
            if (!(!this.includeImports && kid instanceof ASTImportDeclaration || !this.includeComments && kid instanceof Comment)) {
                kids.add(kid);
            }
            ++i;
        }
        Collections.sort(kids, ByLineNumber);
        return kids;
    }

    public Object[] getElements(Object inputElement) {
        AbstractNode parent = (AbstractNode)inputElement;
        return this.withoutHiddenOnes(parent).toArray();
    }

    public Object[] getChildren(Object parentElement) {
        AbstractNode parent = (AbstractNode)parentElement;
        return this.withoutHiddenOnes(parent).toArray();
    }

    public Object getParent(Object element) {
        AbstractNode parent = (AbstractNode)element;
        return parent.jjtGetParent();
    }

    public boolean hasChildren(Object element) {
        AbstractNode parent = (AbstractNode)element;
        return parent.jjtGetNumChildren() > 0;
    }

    public static void setupSorter(TableViewer viewer) {
    }
}

