/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.editors;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import net.sourceforge.pmd.eclipse.ui.editors.BasicLineStyleListener;
import net.sourceforge.pmd.eclipse.ui.editors.SyntaxData;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class SyntaxManager {
    private static Map<String, SyntaxData> syntaxByExtension = new Hashtable<String, SyntaxData>();

    public static ModifyListener adapt(final StyledText codeField, String languageCode, ModifyListener oldListener) {
        SyntaxData sd;
        if (oldListener != null) {
            codeField.removeModifyListener(oldListener);
        }
        if ((sd = SyntaxManager.getSyntaxData(languageCode)) == null) {
            return null;
        }
        final BasicLineStyleListener blsl = new BasicLineStyleListener(sd);
        codeField.addLineStyleListener((LineStyleListener)blsl);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                blsl.refreshMultilineComments(codeField.getText());
                codeField.redraw();
            }
        };
        codeField.addModifyListener(ml);
        return ml;
    }

    public static synchronized SyntaxData getSyntaxData(String extension) {
        SyntaxData sd = syntaxByExtension.get(extension);
        if (sd == null && (sd = SyntaxManager.loadSyntaxData(extension)) != null) {
            syntaxByExtension.put(sd.getExtension(), sd);
        }
        return sd;
    }

    private static SyntaxData loadSyntaxData(String filename) {
        SyntaxData sd = null;
        try {
            ResourceBundle rb = ResourceBundle.getBundle("net.sourceforge.pmd.eclipse.ui.editors." + filename);
            sd = new SyntaxData(filename);
            sd.stringStart = rb.getString("stringstart");
            sd.stringEnd = rb.getString("stringend");
            sd.setMultiLineCommentStart(rb.getString("multilinecommentstart"));
            sd.setMultiLineCommentEnd(rb.getString("multilinecommentend"));
            HashSet<String> keywords = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(rb.getString("keywords"), " ");
            while (st.hasMoreTokens()) {
                keywords.add(st.nextToken());
            }
            sd.setKeywords(keywords);
            sd.setPunctuation(rb.getString("punctuation"));
            if (rb.containsKey("comment")) {
                sd.setComment(rb.getString("comment"));
            }
            if (rb.containsKey("varnamedelimiter")) {
                sd.varnameReference = rb.getString("varnamedelimiter");
            }
        }
        catch (MissingResourceException missingResourceException) {}
        return sd;
    }
}

