/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.builder;

import java.util.Map;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class PMDBuilder
extends IncrementalProjectBuilder {
    public static final Logger log = Logger.getLogger(PMDBuilder.class);
    public static final String PMD_BUILDER = "net.sourceforge.pmd.eclipse.plugin.pmdBuilder";
    public static final IProject[] EMPTY_PROJECT_ARRAY = new IProject[0];

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        log.info((Object)"Incremental builder activated");
        try {
            if (kind == 9) {
                log.debug((Object)"Auto build requested.");
                this.buildAuto(monitor);
            } else if (kind == 6) {
                log.debug((Object)"Full build requested.");
                this.buildFull(monitor);
            } else if (kind == 10) {
                log.debug((Object)"Incremental build requested.");
                this.buildIncremental(monitor);
            } else {
                log.warn((Object)("This kind of build is not supported : " + kind));
            }
        }
        catch (CommandException e) {
            throw new CoreException((IStatus)new Status(4, PMDPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
        }
        log.info((Object)"Build done.");
        return EMPTY_PROJECT_ARRAY;
    }

    private void buildAuto(IProgressMonitor monitor) throws CommandException {
        this.buildIncremental(monitor);
    }

    private void buildFull(IProgressMonitor monitor) throws CommandException {
        IProject currentProject = this.getProject();
        if (currentProject != null) {
            this.processProjectFiles(currentProject, monitor);
        }
    }

    private void buildIncremental(IProgressMonitor monitor) throws CommandException {
        IProject currentProject = this.getProject();
        if (currentProject != null) {
            IResourceDelta resourceDelta = this.getDelta(currentProject);
            if (resourceDelta != null && resourceDelta.getAffectedChildren().length != 0) {
                ReviewCodeCmd cmd = new ReviewCodeCmd();
                cmd.setResourceDelta(resourceDelta);
                cmd.setTaskMarker(false);
                cmd.setMonitor(monitor);
                cmd.performExecute();
            } else {
                log.info((Object)"No change reported. Performing no build");
            }
        }
    }

    private void processProjectFiles(IProject project, IProgressMonitor monitor) throws CommandException {
        ReviewCodeCmd cmd = new ReviewCodeCmd();
        cmd.addResource((IResource)project);
        cmd.setTaskMarker(false);
        cmd.setMonitor(monitor);
        cmd.performExecute();
    }
}

