/*
 * Decompiled with CFR 0.152.
 */
package name.herlin.command;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import name.herlin.command.AbstractProcessableCommand;
import name.herlin.command.CommandProcessor;
import name.herlin.command.CommandProcessorStrategy;
import name.herlin.command.DefaultCommandProcessor;

public class DefaultCommandProcessorStrategy
implements CommandProcessorStrategy {
    private static final CommandProcessor DEFAULT_COMMAND_PROCESSOR = new DefaultCommandProcessor();
    private final Map<String, String> registeredCommandProcessors = new Hashtable<String, String>();

    public DefaultCommandProcessorStrategy() {
        this.loadBundle();
    }

    @Override
    public CommandProcessor getCommandProcessor(AbstractProcessableCommand aCommand) {
        CommandProcessor aProcessor = this.getRegisteredCommandProcessor(aCommand);
        if (aProcessor == null) {
            aProcessor = aCommand.getPreferredCommandProcessor();
        }
        if (aProcessor == null) {
            aProcessor = DEFAULT_COMMAND_PROCESSOR;
        }
        return aProcessor;
    }

    protected CommandProcessor getRegisteredCommandProcessor(AbstractProcessableCommand aCommand) {
        CommandProcessor aProcessor = null;
        try {
            String processorClassName = this.registeredCommandProcessors.get(aCommand.getName());
            if (processorClassName != null) {
                Class<?> clazz = Class.forName(processorClassName);
                aProcessor = (CommandProcessor)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return aProcessor;
    }

    private void loadBundle() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("properties.CommandProcessorStrategy");
            Enumeration<String> e = bundle.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String value = bundle.getString(key);
                this.registeredCommandProcessors.put(key, value);
            }
        }
        catch (RuntimeException runtimeException) {}
    }
}

