/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathManager {
    private List<Entry> entries;
    private List<ZipFile> openArchives = new ArrayList<ZipFile>();
    private static int maxOpenArchives = -1;
    private static final int MAXOPEN_DEFAULT = 1000;
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(ClassPathManager.class);

    public ClassPathManager(List<String> classpath, IMessageHandler handler) {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", (Object)this, new Object[]{classpath, handler});
        }
        this.entries = new ArrayList<Entry>();
        for (String name : classpath) {
            this.addPath(name, handler);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    protected ClassPathManager() {
    }

    public void addPath(String name, IMessageHandler handler) {
        File f = new File(name);
        String lc = name.toLowerCase();
        if (!f.isDirectory()) {
            if (!f.isFile()) {
                if (!lc.endsWith(".jar") || lc.endsWith(".zip")) {
                    MessageUtil.info(handler, WeaverMessages.format("zipfileEntryMissing", name));
                } else {
                    MessageUtil.info(handler, WeaverMessages.format("directoryEntryMissing", name));
                }
                return;
            }
            try {
                this.entries.add(new ZipFileEntry(f));
            }
            catch (IOException ioe) {
                MessageUtil.warn(handler, WeaverMessages.format("zipfileEntryInvalid", name, ioe.getMessage()));
                return;
            }
        } else {
            this.entries.add(new DirEntry(f));
        }
    }

    public ClassFile find(UnresolvedType type) {
        String name = type.getName();
        Iterator<Entry> i = this.entries.iterator();
        while (i.hasNext()) {
            Entry entry = i.next();
            try {
                ClassFile ret = entry.find(name);
                if (ret == null) continue;
                return ret;
            }
            catch (IOException ioe) {
                i.remove();
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        boolean start = true;
        Iterator<Entry> i = this.entries.iterator();
        while (i.hasNext()) {
            if (start) {
                start = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(i.next());
        }
        return buf.toString();
    }

    static boolean hasClassExtension(String name) {
        return name.toLowerCase().endsWith(".class");
    }

    public void closeArchives() {
        for (Entry entry : this.entries) {
            if (entry instanceof ZipFileEntry) {
                ((ZipFileEntry)entry).close();
            }
            this.openArchives.clear();
        }
    }

    private static String getSystemPropertyWithoutSecurityException(String aPropertyName, String aDefaultValue) {
        try {
            return System.getProperty(aPropertyName, aDefaultValue);
        }
        catch (SecurityException ex) {
            return aDefaultValue;
        }
    }

    static {
        String openzipsString = ClassPathManager.getSystemPropertyWithoutSecurityException("org.aspectj.weaver.openarchives", Integer.toString(1000));
        maxOpenArchives = Integer.parseInt(openzipsString);
        if (maxOpenArchives < 20) {
            maxOpenArchives = 1000;
        }
    }

    public static abstract class ClassFile {
        public abstract InputStream getInputStream() throws IOException;

        public abstract String getPath();

        public abstract void close();
    }

    public class DirEntry
    extends Entry {
        private String dirPath;

        public DirEntry(File dir) {
            this.dirPath = dir.getPath();
        }

        public DirEntry(String dirPath) {
            this.dirPath = dirPath;
        }

        public ClassFile find(String name) {
            File f = new File(this.dirPath + File.separator + name.replace('.', File.separatorChar) + ".class");
            if (f.isFile()) {
                return new FileClassFile(f);
            }
            return null;
        }

        public List getAllClassFiles() {
            throw new RuntimeException("unimplemented");
        }

        public String toString() {
            return this.dirPath;
        }
    }

    public static abstract class Entry {
        public abstract ClassFile find(String var1) throws IOException;
    }

    private static class FileClassFile
    extends ClassFile {
        private File file;
        private FileInputStream fis;

        public FileClassFile(File file) {
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            this.fis = new FileInputStream(this.file);
            return this.fis;
        }

        public void close() {
            try {
                if (this.fis != null) {
                    this.fis.close();
                }
            }
            catch (IOException ioe) {
                throw new BCException("Can't close class file : " + this.file.getName(), ioe);
            }
            finally {
                this.fis = null;
            }
        }

        public String getPath() {
            return this.file.getPath();
        }
    }

    private static class ZipEntryClassFile
    extends ClassFile {
        private ZipEntry entry;
        private ZipFileEntry zipFile;
        private InputStream is;

        public ZipEntryClassFile(ZipFileEntry zipFile, ZipEntry entry) {
            this.zipFile = zipFile;
            this.entry = entry;
        }

        public InputStream getInputStream() throws IOException {
            this.is = this.zipFile.getZipFile().getInputStream(this.entry);
            return this.is;
        }

        public void close() {
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.is = null;
            }
        }

        public String getPath() {
            return this.entry.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZipFileEntry
    extends Entry {
        private File file;
        private ZipFile zipFile;

        public ZipFileEntry(File file) throws IOException {
            this.file = file;
        }

        public ZipFileEntry(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        public ZipFile getZipFile() {
            return this.zipFile;
        }

        @Override
        public ClassFile find(String name) throws IOException {
            this.ensureOpen();
            String key = name.replace('.', '/') + ".class";
            ZipEntry entry = this.zipFile.getEntry(key);
            if (entry != null) {
                return new ZipEntryClassFile(this, entry);
            }
            return null;
        }

        public List<ZipEntryClassFile> getAllClassFiles() throws IOException {
            this.ensureOpen();
            ArrayList<ZipEntryClassFile> ret = new ArrayList<ZipEntryClassFile>();
            Enumeration<? extends ZipEntry> e = this.zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String name = entry.getName();
                if (!ClassPathManager.hasClassExtension(name)) continue;
                ret.add(new ZipEntryClassFile(this, entry));
            }
            return ret;
        }

        private void ensureOpen() throws IOException {
            if (this.zipFile != null && ClassPathManager.this.openArchives.contains(this.zipFile) && this.isReallyOpen()) {
                return;
            }
            if (ClassPathManager.this.openArchives.size() >= maxOpenArchives) {
                this.closeSomeArchives(ClassPathManager.this.openArchives.size() / 10);
            }
            this.zipFile = new ZipFile(this.file);
            if (!this.isReallyOpen()) {
                throw new FileNotFoundException("Can't open archive: " + this.file.getName() + " (size() check failed)");
            }
            ClassPathManager.this.openArchives.add(this.zipFile);
        }

        private boolean isReallyOpen() {
            try {
                this.zipFile.size();
                return true;
            }
            catch (IllegalStateException ex) {
                return false;
            }
        }

        public void closeSomeArchives(int n) {
            for (int i = n - 1; i >= 0; --i) {
                ZipFile zf = (ZipFile)ClassPathManager.this.openArchives.get(i);
                try {
                    zf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ClassPathManager.this.openArchives.remove(i);
            }
        }

        public void close() {
            if (this.zipFile == null) {
                return;
            }
            try {
                ClassPathManager.this.openArchives.remove(this.zipFile);
                this.zipFile.close();
            }
            catch (IOException ioe) {
                throw new BCException("Can't close archive: " + this.file.getName(), ioe);
            }
            finally {
                this.zipFile = null;
            }
        }

        public String toString() {
            return this.file.getName();
        }
    }
}

