/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.domain;

import org.hibernate.internal.util.Value;
import org.hibernate.service.classloading.spi.ClassLoaderService;

public class JavaType {
    private final String name;
    private final Value<Class<?>> classReference;

    public JavaType(final String name, final ClassLoaderService classLoaderService) {
        this.name = name;
        this.classReference = new Value<1>(new Value.DeferredInitializer<Class<?>>(){

            @Override
            public Class<?> initialize() {
                return classLoaderService.classForName(name);
            }
        });
    }

    public JavaType(Class<?> theClass) {
        this.name = theClass.getName();
        this.classReference = new Value(theClass);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getClassReference() {
        return this.classReference.getValue();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

