/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.ui.navigator.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.aop.ui.Activator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AopReferenceModelNavigatorUtils {
    public static ILabelProvider JAVA_LABEL_PROVIDER = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT | 0x100), Activator.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
    private static Map<Object, Object> workingCopyManagersForEditors = new HashMap<Object, Object>();
    private static boolean selectedOutsideJavaElement = false;

    public static Object getSelectedElement(IWorkbenchPart part, ISelection selection) {
        Object selectedElement = AopReferenceModelNavigatorUtils.getSelectedJavaElement(part, selection);
        if (selectedElement == null) {
            selectedElement = AopReferenceModelNavigatorUtils.getSelectedXmlElement(selection);
        }
        return selectedElement;
    }

    private static Object getSelectedXmlElement(ISelection selection) {
        Object selectedElement = null;
        if (selection instanceof IStructuredSelection) {
            Node parent;
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            Object obj = structSelection.getFirstElement();
            if (obj instanceof Attr) {
                obj = ((Attr)obj).getOwnerElement();
            }
            if (obj instanceof Element) {
                Node parentBean;
                Element elem = (Element)obj;
                selectedElement = obj;
                if ("http://www.springframework.org/schema/aop".equals(elem.getNamespaceURI())) {
                    if ("aspect".equals(elem.getLocalName())) {
                        selectedElement = AopReferenceModelNavigatorUtils.locateAspectReference(elem, BeansEditorUtils.getAttribute((Node)elem, (String)"ref"));
                    } else if ("advisor".equals(elem.getLocalName())) {
                        selectedElement = AopReferenceModelNavigatorUtils.locateAspectReference(elem, BeansEditorUtils.getAttribute((Node)elem, (String)"advice-ref"));
                    } else if (elem.getParentNode() != null && "aspect".equals(elem.getParentNode().getLocalName())) {
                        selectedElement = AopReferenceModelNavigatorUtils.locateAspectReference(elem.getParentNode(), BeansEditorUtils.getAttribute((Node)elem.getParentNode(), (String)"ref"));
                    } else if (!"config".equals(elem.getLocalName())) {
                        selectedElement = AopReferenceModelNavigatorUtils.locateAspectReference(elem, BeansEditorUtils.getAttribute((Node)elem, (String)"ref"));
                    }
                } else if (("".equals(elem.getNamespaceURI()) || "http://www.springframework.org/schema/beans".equals(elem.getNamespaceURI())) && (parentBean = AopReferenceModelNavigatorUtils.getBeanElement(elem, "bean")) != null) {
                    selectedElement = parentBean;
                }
            } else if (obj instanceof Text && (parent = ((Text)obj).getParentNode()) instanceof Element) {
                selectedElement = AopReferenceModelNavigatorUtils.getSelectedXmlElement((ISelection)new StructuredSelection((Object)parent));
            }
        }
        return selectedElement;
    }

    private static Node getBeanElement(Node elem, String nodeName) {
        if (!nodeName.equals(elem.getLocalName()) && !elem.getOwnerDocument().equals(elem.getParentNode())) {
            return AopReferenceModelNavigatorUtils.getBeanElement(elem.getParentNode(), nodeName);
        }
        return elem;
    }

    private static Object locateAspectReference(Node elem, String ref) {
        Node selectedElement = null;
        if (StringUtils.hasText((String)ref)) {
            NodeList beans = elem.getOwnerDocument().getElementsByTagName("bean");
            if (beans != null && beans.getLength() > 0) {
                int i = 0;
                while (i < beans.getLength()) {
                    Node node = beans.item(i);
                    if (ref.equals(BeansEditorUtils.getAttribute((Node)node, (String)"id"))) {
                        selectedElement = node;
                        break;
                    }
                    ++i;
                }
            }
            if (selectedElement == null) {
                selectedElement = elem.getOwnerDocument().getElementById(ref);
            }
        }
        return selectedElement;
    }

    public static IJavaElement getSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IJavaElement && !(first instanceof IJavaProject)) {
                return (IJavaElement)first;
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            ISourceReference sourceRef = AopReferenceModelNavigatorUtils.computeHighlightRangeSourceReference(je);
            IJavaElement javaElement = (IJavaElement)sourceRef;
            return javaElement;
        }
        return null;
    }

    public static ISourceReference computeHighlightRangeSourceReference(JavaEditor editor) {
        ISourceViewer sourceViewer = editor.getViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = AopReferenceModelNavigatorUtils.getElementAt(editor, caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private static IJavaElement getElementAt(JavaEditor editor, int offset, boolean reconcile) {
        block20: {
            void var3_5;
            if (workingCopyManagersForEditors.get(editor) instanceof IWorkingCopyManager) {
                IWorkingCopyManager iWorkingCopyManager = (IWorkingCopyManager)workingCopyManagersForEditors.get(editor);
            } else {
                WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
            }
            ICompilationUnit unit = var3_5.getWorkingCopy(editor.getEditorInput());
            if (unit != null) {
                try {
                    if (reconcile) {
                        IJavaElement[] children;
                        ICompilationUnit iCompilationUnit = unit;
                        synchronized (iCompilationUnit) {
                            unit.reconcile(0, false, null, null);
                        }
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IJavaElement[] iJavaElementArray = children = unit.getChildren();
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IJavaElement element = iJavaElementArray[n2];
                            if (element instanceof SourceType) {
                                return element;
                            }
                            ++n2;
                        }
                        break block20;
                    }
                    if (unit.isConsistent()) {
                        IJavaElement elementAt = unit.getElementAt(offset);
                        if (elementAt != null) {
                            return elementAt;
                        }
                        IResource res = unit.getCorrespondingResource();
                        if (res instanceof IFile) {
                            IMarker[] javaModelMarkers;
                            IFile file = (IFile)res;
                            IProject containingProject = file.getProject();
                            IMarker[] iMarkerArray = javaModelMarkers = containingProject.findMarkers("org.eclipse.jdt.core.problem", false, 2);
                            int n = javaModelMarkers.length;
                            int n3 = 0;
                            while (n3 < n) {
                                IMarker marker = iMarkerArray[n3];
                                if (marker.getResource().equals((Object)file)) {
                                    return null;
                                }
                                ++n3;
                            }
                        }
                        if (elementAt == null && unit.getChildren().length != 0) {
                            selectedOutsideJavaElement = true;
                            return unit.getChildren()[0];
                        }
                    }
                }
                catch (JavaModelException x) {
                    if (!x.isDoesNotExist()) {
                        JavaPlugin.log((IStatus)x.getStatus());
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    public static int getLineNumber(IMember member) {
        try {
            ICompilationUnit compUnit = member.getCompilationUnit();
            if (compUnit != null) {
                Document document = new Document(compUnit.getBuffer().getContents());
                return document.getLineOfOffset(member.getSourceRange().getOffset());
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }
}

