/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.QuickfixReflectionUtils;

public class RenameMethodQuickfixProposal
extends BeanAttributeQuickFixProposal
implements ICompletionProposal {
    private final String className;
    private final String methodName;
    private final IFile beanFile;
    private final IProject project;
    private IEditorPart editor;

    public RenameMethodQuickfixProposal(int offset, int length, String text, String className, boolean missingEndQuote, IFile beanFile, IProject project) {
        super(offset, length, missingEndQuote);
        this.className = className;
        this.beanFile = beanFile;
        this.methodName = text;
        this.project = project;
    }

    @Override
    public void applyQuickFix(IDocument document) {
        final LinkedPosition position = new LinkedPosition(document, this.getOffset(), this.getLength());
        LinkedPositionGroup group = new LinkedPositionGroup();
        LinkedModeModel model = new LinkedModeModel();
        try {
            group.addPosition(position);
            model.addGroup(group);
            model.forceInstall();
            ITextViewer viewer = this.getViewer(document);
            if (viewer == null) {
                return;
            }
            Point originalSelection = viewer.getSelectedRange();
            LinkedModeUI ui = new LinkedModeUI(model, viewer);
            ui.setExitPosition(viewer, this.getOffset(), 0, Integer.MAX_VALUE);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel model, int flags) {
                    if ((flags & 2) > 0) {
                        try {
                            String newName = position.getContent();
                            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                            RenameMethodQuickfixProposal.this.doRename(newName, shell);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }

                public void resume(LinkedModeModel model, int flags) {
                }

                public void suspend(LinkedModeModel model) {
                }
            });
            ui.enter();
            viewer.setSelectedRange(originalSelection.x, originalSelection.y);
        }
        catch (BadLocationException badLocationException) {}
    }

    public void doRename(String newMethodName, Shell shell) {
        try {
            IMethod method;
            IType type = JdtUtils.getJavaType((IProject)this.project, (String)this.className);
            if (type != null && (method = Introspector.findMethod((IType)type, (String)this.methodName, (int)0, (Introspector.Public)Introspector.Public.DONT_CARE, (Introspector.Static)Introspector.Static.DONT_CARE)) != null) {
                RenameSupport renameSupport = RenameSupport.create((IMethod)method, (String)newMethodName, (int)1);
                renameSupport.perform(shell, (IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                if (this.editor instanceof EditorPart) {
                    ((EditorPart)this.editor).doSave((IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (CoreException coreException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public String getDisplayString() {
        return "Rename method in file";
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_linked_rename.gif");
    }

    private ITextViewer getViewer(IDocument document) {
        try {
            if (this.editor == null) {
                this.editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.beanFile);
            }
            return this.getViewer(this.editor);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    private ITextViewer getViewer(IEditorPart editorPart) {
        if (editorPart instanceof IConfigEditor) {
            IConfigEditor configEditor = (IConfigEditor)editorPart;
            return configEditor.getTextViewer();
        }
        if (editorPart instanceof StructuredTextEditor) {
            return ((StructuredTextEditor)editorPart).getTextViewer();
        }
        if (editorPart instanceof XMLMultiPageEditorPart) {
            Object result = QuickfixReflectionUtils.callProtectedMethod(editorPart, "getTextEditor");
            return this.getViewer((IEditorPart)result);
        }
        return null;
    }
}

