/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.processors.BeanReferenceQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.proposals.AddStaticToFieldQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewClassQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewFieldQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.CreateNewMethodQuickFixProposal;

public class NameSpaceElementsQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final String problemId;
    private final IJavaProject javaProject;
    private final ValidationProblemAttribute[] problemAttributes;
    private final IDOMNode node;
    private final IFile file;

    public NameSpaceElementsQuickAssistProcessor(String problemId, int offset, int length, String text, boolean missingEndQuote, IProject project, IDOMNode node, IFile file, ValidationProblemAttribute ... problemAttributes) {
        super(offset, length, text, missingEndQuote);
        this.problemId = problemId;
        this.node = node;
        this.file = file;
        this.problemAttributes = problemAttributes;
        this.javaProject = JavaCore.create((IProject)project).getJavaProject();
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        IType type;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String className = null;
        String fieldName = null;
        String methodName = null;
        String beanName = null;
        ValidationProblemAttribute[] validationProblemAttributeArray = this.problemAttributes;
        int n = this.problemAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            ValidationProblemAttribute problemAttribute = validationProblemAttributeArray[n2];
            if ("CLASS".equals(problemAttribute.getKey())) {
                className = (String)problemAttribute.getValue();
            } else if ("FIELD".equals(problemAttribute.getKey())) {
                fieldName = (String)problemAttribute.getValue();
            } else if ("METHOD".equals(problemAttribute.getKey())) {
                methodName = (String)problemAttribute.getValue();
            } else if ("BEAN".equals(problemAttribute.getKey())) {
                beanName = (String)problemAttribute.getValue();
            }
            ++n2;
        }
        if ("CLASS_NOT_FOUND".equals(this.problemId) && className != null) {
            proposals.add(new CreateNewClassQuickFixProposal(this.offset, this.length, className, this.missingEndQuote, this.javaProject, new HashSet<String>(), 0));
        } else if ("FIELD_NOT_FOUND".equals(this.problemId) && className != null && fieldName != null) {
            type = JdtUtils.getJavaType((IProject)this.javaProject.getProject(), (String)className);
            if (!type.isReadOnly()) {
                proposals.add(new CreateNewFieldQuickFixProposal(this.offset, this.length, this.text, this.missingEndQuote, this.javaProject, className, fieldName));
            }
        } else if ("FIELD_NOT_STATIC".equals(this.problemId) && className != null && fieldName != null) {
            type = JdtUtils.getJavaType((IProject)this.javaProject.getProject(), (String)className);
            if (!type.isReadOnly()) {
                proposals.add(new AddStaticToFieldQuickFixProposal(this.offset, this.length, this.missingEndQuote, this.javaProject, className, fieldName));
            }
        } else if ("METHOD_NOT_FOUND".equals(this.problemId) && className != null && methodName != null) {
            CreateNewMethodQuickFixProposal proposal = QuickfixUtils.getNewMethodQuickFixProposal(methodName, "Object", new String[0], this.javaProject, className, this.offset, this.length, this.text, this.missingEndQuote, false, "method");
            if (proposal != null) {
                proposals.add(proposal);
            }
        } else if ("UNDEFINED_REFERENCED_BEAN".equals(this.problemId) && beanName != null) {
            proposals.addAll(BeanReferenceQuickAssistProcessor.computeBeanReferenceQuickAssistProposals(this.node, BeansSchemaConstants.ATTR_REF, this.file, this.text, beanName, this.offset, this.length, this.missingEndQuote));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }
}

