/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddRequestMappingCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class RequestMappingAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    @Override
    public String getAnnotationName() {
        return "RequestMapping";
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        if (super.isQuickfixAvailable(methodDecl, context)) {
            MethodDeclaration node = methodDecl;
            TypeDeclaration typeDecl = null;
            while (node != null && typeDecl == null) {
                if (node instanceof TypeDeclaration) {
                    typeDecl = (TypeDeclaration)node;
                }
                node = node.getParent();
            }
            if (typeDecl != null) {
                return ProposalCalculatorUtil.hasAnnotation("Controller", typeDecl);
            }
        }
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        return super.isQuickfixAvailable(typeDecl, context) && ProposalCalculatorUtil.hasAnnotation("Controller", (ASTNode)typeDecl);
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssistsForDecl((BodyDeclaration)methodDecl, name, cu);
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForType(TypeDeclaration typeDecl, SimpleName name, ICompilationUnit cu) {
        return this.getAssistsForDecl((BodyDeclaration)typeDecl, name, cu);
    }

    private List<IJavaCompletionProposal> getAssistsForDecl(BodyDeclaration decl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddRequestMappingCompletionProposal(name.getFullyQualifiedName(), decl, cu, name.getStartPosition(), name.getLength(), 1));
        return proposals;
    }
}

