/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard;

import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelectionHandler;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.IProjectSelector;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ProjectSelectionPart;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt.ProjectSelectorFactory;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.wizard.GenericCommandWizard;

public abstract class AbstractGenericWizardPage
extends WizardPage {
    private IProjectSelector projectSelector;

    protected AbstractGenericWizardPage(String pageName) {
        super(pageName);
    }

    protected int getPageWMargin() {
        return this.convertVerticalDLUsToPixels(7);
    }

    protected int getPageHMargin() {
        return this.convertHorizontalDLUsToPixels(7);
    }

    public void createControl(Composite parent) {
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        this.initializeDialogUnits((Control)parent);
        Composite wizardArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        wizardArea.setLayout((Layout)layout);
        this.createProjectSelectionArea(wizardArea);
        this.createPageArea(wizardArea);
        Dialog.applyDialogFont((Control)wizardArea);
        this.setControl((Control)wizardArea);
    }

    protected void setProjectInWizard(IProject selectedProject) {
        GenericCommandWizard commandWizard = this.getGenericCommandWizard();
        commandWizard.setSelectedProject(selectedProject);
    }

    protected GenericCommandWizard getGenericCommandWizard() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof GenericCommandWizard) {
            return (GenericCommandWizard)wizard;
        }
        return null;
    }

    protected void setProjectSelectionInPage() {
        IProject project;
        GenericCommandWizard wizard = this.getGenericCommandWizard();
        if (wizard != null && (project = wizard.getSelectedProject()) != null && this.projectSelector != null) {
            this.projectSelector.setProject(project);
        }
    }

    public IWizardPage getNextPage() {
        this.setProjectSelectionInPage();
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        this.setProjectSelectionInPage();
        return super.getPreviousPage();
    }

    protected void createProjectSelectionArea(Composite parent) {
        Collection<IProject> projects;
        GenericCommandWizard commandWizard = this.getGenericCommandWizard();
        if (commandWizard != null && (projects = commandWizard.getProjectList()) != null && projects.size() > 0) {
            IProjectSelectionHandler handler = new IProjectSelectionHandler(){

                @Override
                public void handleProjectSelectionChange(IProject project) {
                    AbstractGenericWizardPage.this.setProjectInWizard(project);
                }
            };
            this.projectSelector = new ProjectSelectorFactory(this.getShell(), parent, projects, handler).getProjectSelector();
            if (this.projectSelector != null) {
                if (this.projectSelector instanceof ProjectSelectionPart) {
                    ((ProjectSelectionPart)this.projectSelector).showProjectSwitchDialogue(false);
                }
                this.projectSelector.createProjectArea();
                if (commandWizard.getSelectedProject() == null) {
                    IProject currentSelection = this.projectSelector.getSelectedProject();
                    this.setProjectInWizard(currentSelection);
                } else {
                    IProject wizardProject = commandWizard.getSelectedProject();
                    this.projectSelector.setProject(wizardProject);
                }
            }
        }
    }

    protected abstract Composite createPageArea(Composite var1);
}

