/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.path;

public abstract class YamlPathSegment {
    public String toString() {
        return this.toNavString();
    }

    public abstract String toNavString();

    public abstract String toPropString();

    public abstract Integer toIndex();

    public abstract YamlPathSegmentType getType();

    public static YamlPathSegment valueAt(String key) {
        return new ValAtKey(key);
    }

    public static YamlPathSegment valueAt(int index) {
        return new AtIndex(index);
    }

    public static YamlPathSegment keyAt(String key) {
        return new KeyAtKey(key);
    }

    public static class AtIndex
    extends YamlPathSegment {
        private int index;

        public AtIndex(int index) {
            this.index = index;
        }

        @Override
        public String toNavString() {
            return "[" + this.index + "]";
        }

        @Override
        public String toPropString() {
            return "[" + this.index + "]";
        }

        @Override
        public YamlPathSegmentType getType() {
            return YamlPathSegmentType.VAL_AT_INDEX;
        }

        @Override
        public Integer toIndex() {
            return this.index;
        }
    }

    private static class KeyAtKey
    extends ValAtKey {
        public KeyAtKey(String key) {
            super(key);
        }

        @Override
        public YamlPathSegmentType getType() {
            return YamlPathSegmentType.KEY_AT_KEY;
        }
    }

    public static class ValAtKey
    extends YamlPathSegment {
        private String key;

        public ValAtKey(String key) {
            this.key = key;
        }

        @Override
        public String toNavString() {
            if (this.key.indexOf(46) >= 0) {
                return "[" + this.key + "]";
            }
            return "." + this.key;
        }

        @Override
        public String toPropString() {
            return this.key;
        }

        @Override
        public YamlPathSegmentType getType() {
            return YamlPathSegmentType.VAL_AT_KEY;
        }

        @Override
        public Integer toIndex() {
            return null;
        }
    }

    public static enum YamlPathSegmentType {
        VAL_AT_KEY,
        KEY_AT_KEY,
        VAL_AT_INDEX;

    }
}

