/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.graph.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphImages;
import org.springframework.ide.eclipse.beans.ui.graph.BeansGraphPlugin;
import org.springframework.ide.eclipse.beans.ui.graph.editor.GraphEditor;
import org.springframework.ide.eclipse.core.SpringCoreUtils;

public class ExportAction
extends WorkbenchPartAction {
    public static final String ID = "Export_action";
    private GraphEditor editor;

    public ExportAction(GraphEditor part) {
        super((IWorkbenchPart)part);
        this.editor = part;
        this.setText("Export");
        this.setId(ID);
        this.setToolTipText("Exports to an image");
        this.setImageDescriptor(BeansGraphImages.DESC_OBJS_EXPORT_ENABLED);
        this.setDisabledImageDescriptor(BeansGraphImages.DESC_OBJS_EXPORT_DISABLED);
    }

    public void run() {
        SaveAsDialog dialog = new SaveAsDialog(this.getWorkbenchPart().getSite().getShell());
        dialog.setOriginalName("graph.jpg");
        dialog.create();
        dialog.setMessage(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.message"));
        dialog.setOriginalName("graph.png");
        dialog.open();
        IPath path = dialog.getResult();
        if (path != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IFile file = workspace.getRoot().getFile(path);
            String ext = file.getFileExtension();
            if (ext == null || ext.length() == 0 || !ext.equalsIgnoreCase("jpg") && !ext.equalsIgnoreCase("bmp") && !ext.equalsIgnoreCase("png")) {
                ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.title"), null, (IStatus)BeansGraphPlugin.createErrorStatus(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.error")));
            } else if (ext.equalsIgnoreCase("PNG") && !SpringCoreUtils.isEclipseSameOrNewer((int)3, (int)3)) {
                ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)"Problem", (String)"Exporting to PNG format is only supported on Eclipse 3.3 or newer", (IStatus)BeansGraphPlugin.createErrorStatus(BeansGraphPlugin.getResourceString("Editor.SaveAsDialog.error")));
            } else if ("PNG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 5);
            } else if ("JPG".equalsIgnoreCase(ext) || "JPEG".equalsIgnoreCase(ext)) {
                this.saveImage(file, 4);
            } else if ("BMP".equalsIgnoreCase(ext)) {
                this.saveImage(file, 0);
            }
        }
    }

    public void saveImage(final IFile file, final int format) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    if (file.exists()) {
                        file.setContents((InputStream)new ByteArrayInputStream(ExportAction.this.createImage(format)), true, false, monitor);
                    } else {
                        file.create((InputStream)new ByteArrayInputStream(ExportAction.this.createImage(format)), true, monitor);
                    }
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)ExportAction.this.getWorkbenchPart().getSite().getShell(), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.title"), (String)BeansGraphPlugin.getResourceString("Editor.SaveError.text"), (IStatus)e.getStatus());
                }
            }
        };
        try {
            Shell shell = this.getWorkbenchPart().getSite().getWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            BeansGraphPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {}
    }

    public byte[] createImage(int format) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Display device = this.editor.getGraphicalViewer().getControl().getDisplay();
        LayerManager lm = (LayerManager)this.editor.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        Rectangle r = figure.getClientArea();
        Image image = null;
        GC gc = null;
        SWTGraphics g = null;
        try {
            image = new Image((Device)device, r.width, r.height);
            gc = new GC((Drawable)image);
            g = new SWTGraphics(gc);
            g.translate(r.x * -1, r.y * -1);
            figure.paint((Graphics)g);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save((OutputStream)result, format);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
        return result.toByteArray();
    }

    protected boolean calculateEnabled() {
        return true;
    }
}

