/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.conflicts.MergeFileAssociation;
import org.tigris.subversion.subclipse.ui.conflicts.NewMergeFileAssociationWizard;
import org.tigris.subversion.subclipse.ui.wizards.ClosableWizardDialog;

public class MergeFileAssociationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table table;
    private TableViewer viewer;
    private Button removeButton;
    private Group mergeProgramGroup;
    private Text defaultProgramLocationText;
    private Text defaultProgramParametersText;
    private Combo customProgramLocationCombo;
    private Text customProgramParametersText;
    private Button builtInMergeRadioButton;
    private Button externalMergeRadioButton;
    private Button customMergeRadioButton;
    private Button browseMergeProgramButton;
    private Button variablesButton;
    private IPreferenceStore store;
    private MergeFileAssociation[] mergeFileAssociations;
    private boolean associationsUpdated = false;
    private boolean updating = true;
    private static ArrayList images;
    private String[] columnHeaders = new String[]{""};
    private ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnWeightData(100, 100, true)};

    protected Control createContents(Composite parent) {
        images = new ArrayList();
        this.store = SVNUIPlugin.getPlugin().getPreferenceStore();
        this.mergeFileAssociations = this.getMergeFileAssociations();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        Label fileTypesLabel = new Label(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fileTypesLabel.setLayoutData((Object)gridData);
        fileTypesLabel.setText(Policy.bind("MergeFileAssociationPreferencePage.fileTypes"));
        this.table = new Table(composite, 68352);
        this.table.setLinesVisible(false);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.heightHint = 200;
        this.table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(false);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new MergeFileAssociationsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MergeFileAssociationsLabelProvider());
        int i = 0;
        while (i < this.columnHeaders.length) {
            tableLayout.addColumnData(this.columnLayouts[i]);
            TableColumn tc = new TableColumn(this.table, 0, i);
            tc.setResizable(this.columnLayouts[i].resizable);
            tc.setText(this.columnHeaders[i]);
            ++i;
        }
        this.viewer.setInput((Object)this);
        Composite buttonGroup = new Composite(composite, 0);
        gridData = new GridData(768);
        buttonGroup.setLayoutData((Object)gridData);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonGroup.setLayout((Layout)buttonLayout);
        Button addButton = new Button(buttonGroup, 8);
        addButton.setText(Policy.bind("MergeFileAssociationPreferencePage.add"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeFileAssociationPreferencePage.this.addFileType();
            }
        });
        this.removeButton = new Button(buttonGroup, 8);
        this.removeButton.setText(Policy.bind("MergeFileAssociationPreferencePage.remove"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeFileAssociationPreferencePage.this.removeFileType();
            }
        });
        this.mergeProgramGroup = new Group(composite, 0);
        this.mergeProgramGroup.setText(Policy.bind("MergeFileAssociationPreferencePage.mergeProgramGroup"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.mergeProgramGroup.setLayoutData((Object)gridData);
        GridLayout mergeProgramGroupLayout = new GridLayout();
        mergeProgramGroupLayout.numColumns = 3;
        this.mergeProgramGroup.setLayout((Layout)mergeProgramGroupLayout);
        this.builtInMergeRadioButton = new Button((Composite)this.mergeProgramGroup, 16);
        this.builtInMergeRadioButton.setText(Policy.bind("DiffMergePreferencePage.builtInMerge"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.builtInMergeRadioButton.setLayoutData((Object)gridData);
        this.externalMergeRadioButton = new Button((Composite)this.mergeProgramGroup, 16);
        this.externalMergeRadioButton.setText(Policy.bind("MergeFileAssociationPreferencePage.defaultExternal"));
        gridData = new GridData();
        this.defaultProgramLocationText = new Text((Composite)this.mergeProgramGroup, 2048);
        this.defaultProgramLocationText.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 400;
        this.defaultProgramLocationText.setLayoutData((Object)gridData);
        Label defaultParametersLabel = new Label((Composite)this.mergeProgramGroup, 0);
        defaultParametersLabel.setText(Policy.bind("DiffMergePreferencePage.mergeProgramParameters"));
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        defaultParametersLabel.setLayoutData((Object)gridData);
        this.defaultProgramParametersText = new Text((Composite)this.mergeProgramGroup, 2048);
        this.defaultProgramParametersText.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 400;
        this.defaultProgramParametersText.setLayoutData((Object)gridData);
        this.defaultProgramLocationText.setText(this.store.getString("pref_merge_program_location"));
        this.defaultProgramParametersText.setText(this.store.getString("pref_merge_program_parameters"));
        this.customMergeRadioButton = new Button((Composite)this.mergeProgramGroup, 16);
        this.customMergeRadioButton.setText(Policy.bind("MergeFileAssociationPreferencePage.customExternal"));
        this.customProgramLocationCombo = new Combo((Composite)this.mergeProgramGroup, 2048);
        gridData = new GridData();
        gridData.widthHint = 400;
        this.customProgramLocationCombo.setLayoutData((Object)gridData);
        this.customProgramLocationCombo.setEnabled(false);
        int i2 = 0;
        while (i2 < this.mergeFileAssociations.length) {
            if (this.mergeFileAssociations[i2].getType() == 2 && this.customProgramLocationCombo.indexOf(this.mergeFileAssociations[i2].getMergeProgram()) == -1) {
                this.customProgramLocationCombo.add(this.mergeFileAssociations[i2].getMergeProgram());
            }
            ++i2;
        }
        this.browseMergeProgramButton = new Button((Composite)this.mergeProgramGroup, 8);
        this.browseMergeProgramButton.setText(Policy.bind("DiffMergePreferencePage.browse"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.browseMergeProgramButton.setLayoutData((Object)gridData);
        this.browseMergeProgramButton.setEnabled(false);
        this.browseMergeProgramButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(MergeFileAssociationPreferencePage.this.getShell(), 4096);
                String res = fileDialog.open();
                if (res != null) {
                    MergeFileAssociationPreferencePage.this.customProgramLocationCombo.setText(res);
                }
            }
        });
        Label customParametersLabel = new Label((Composite)this.mergeProgramGroup, 0);
        customParametersLabel.setText(Policy.bind("DiffMergePreferencePage.mergeProgramParameters"));
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        customParametersLabel.setLayoutData((Object)gridData);
        this.customProgramParametersText = new Text((Composite)this.mergeProgramGroup, 2048);
        this.defaultProgramParametersText.setEnabled(false);
        gridData = new GridData();
        gridData.widthHint = 400;
        this.customProgramParametersText.setLayoutData((Object)gridData);
        this.variablesButton = new Button((Composite)this.mergeProgramGroup, 8);
        this.variablesButton.setText(Policy.bind("DiffMergePreferencePage.mergeProgramVariables"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.variablesButton.setLayoutData((Object)gridData);
        this.variablesButton.setEnabled(false);
        final Text formatToInsert = this.customProgramParametersText;
        this.variablesButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                MergeFileAssociationPreferencePage.this.addVariables(formatToInsert, MergeFileAssociationPreferencePage.this.getMergeBindingDescriptions());
            }
        });
        this.mergeProgramGroup.setEnabled(false);
        this.viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeFileAssociationPreferencePage.this.updating = false;
                MergeFileAssociationPreferencePage.this.removeButton.setEnabled(!MergeFileAssociationPreferencePage.this.viewer.getSelection().isEmpty());
                MergeFileAssociationPreferencePage.this.mergeProgramGroup.setEnabled(!MergeFileAssociationPreferencePage.this.viewer.getSelection().isEmpty());
                IStructuredSelection selection = (IStructuredSelection)MergeFileAssociationPreferencePage.this.viewer.getSelection();
                MergeFileAssociation mergeFileAssociation = (MergeFileAssociation)selection.getFirstElement();
                if (mergeFileAssociation != null) {
                    switch (mergeFileAssociation.getType()) {
                        case 0: {
                            MergeFileAssociationPreferencePage.this.builtInMergeRadioButton.setSelection(true);
                            MergeFileAssociationPreferencePage.this.externalMergeRadioButton.setSelection(false);
                            MergeFileAssociationPreferencePage.this.customMergeRadioButton.setSelection(false);
                            break;
                        }
                        case 1: {
                            MergeFileAssociationPreferencePage.this.externalMergeRadioButton.setSelection(true);
                            MergeFileAssociationPreferencePage.this.builtInMergeRadioButton.setSelection(false);
                            MergeFileAssociationPreferencePage.this.customMergeRadioButton.setSelection(false);
                            break;
                        }
                        case 2: {
                            MergeFileAssociationPreferencePage.this.customMergeRadioButton.setSelection(true);
                            MergeFileAssociationPreferencePage.this.builtInMergeRadioButton.setSelection(false);
                            MergeFileAssociationPreferencePage.this.externalMergeRadioButton.setSelection(false);
                            break;
                        }
                    }
                    if (mergeFileAssociation.getMergeProgram() == null) {
                        MergeFileAssociationPreferencePage.this.customProgramLocationCombo.setText("");
                    } else {
                        MergeFileAssociationPreferencePage.this.customProgramLocationCombo.setText(mergeFileAssociation.getMergeProgram());
                    }
                    if (mergeFileAssociation.getParameters() == null) {
                        MergeFileAssociationPreferencePage.this.customProgramParametersText.setText("");
                    } else {
                        MergeFileAssociationPreferencePage.this.customProgramParametersText.setText(mergeFileAssociation.getParameters());
                    }
                    MergeFileAssociationPreferencePage.this.customProgramLocationCombo.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                    MergeFileAssociationPreferencePage.this.customProgramParametersText.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                    MergeFileAssociationPreferencePage.this.browseMergeProgramButton.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                    MergeFileAssociationPreferencePage.this.variablesButton.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                }
                MergeFileAssociationPreferencePage.this.updating = true;
            }
        });
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                MergeFileAssociation mergeFileAssociation;
                MergeFileAssociationPreferencePage.this.customProgramLocationCombo.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                MergeFileAssociationPreferencePage.this.customProgramParametersText.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                MergeFileAssociationPreferencePage.this.browseMergeProgramButton.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                MergeFileAssociationPreferencePage.this.variablesButton.setEnabled(MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection());
                if (e.getSource() == MergeFileAssociationPreferencePage.this.customMergeRadioButton && MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection()) {
                    MergeFileAssociationPreferencePage.this.customProgramLocationCombo.setFocus();
                }
                if (e.getSource() == MergeFileAssociationPreferencePage.this.customProgramLocationCombo) {
                    int i = 0;
                    while (i < MergeFileAssociationPreferencePage.this.mergeFileAssociations.length) {
                        if (MergeFileAssociationPreferencePage.this.mergeFileAssociations[i].getType() == 2 && MergeFileAssociationPreferencePage.this.mergeFileAssociations[i].getMergeProgram().equals(MergeFileAssociationPreferencePage.this.customProgramLocationCombo.getText())) {
                            MergeFileAssociationPreferencePage.this.customProgramParametersText.setText(MergeFileAssociationPreferencePage.this.mergeFileAssociations[i].getParameters());
                            break;
                        }
                        ++i;
                    }
                }
                if (e.getSource() instanceof Button && (mergeFileAssociation = (MergeFileAssociation)(selection = (IStructuredSelection)MergeFileAssociationPreferencePage.this.viewer.getSelection()).getFirstElement()) != null) {
                    int type = mergeFileAssociation.getType();
                    if (MergeFileAssociationPreferencePage.this.builtInMergeRadioButton.getSelection()) {
                        type = 0;
                    } else if (MergeFileAssociationPreferencePage.this.externalMergeRadioButton.getSelection()) {
                        type = 1;
                    } else if (MergeFileAssociationPreferencePage.this.customMergeRadioButton.getSelection()) {
                        type = 2;
                    }
                    if (type != mergeFileAssociation.getType()) {
                        MergeFileAssociationPreferencePage.this.associationsUpdated = true;
                        mergeFileAssociation.setType(type);
                    }
                }
            }
        };
        this.builtInMergeRadioButton.addSelectionListener((SelectionListener)selectionListener);
        this.externalMergeRadioButton.addSelectionListener((SelectionListener)selectionListener);
        this.customMergeRadioButton.addSelectionListener((SelectionListener)selectionListener);
        this.customProgramLocationCombo.addSelectionListener((SelectionListener)selectionListener);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStructuredSelection selection = (IStructuredSelection)MergeFileAssociationPreferencePage.this.viewer.getSelection();
                MergeFileAssociation mergeFileAssociation = (MergeFileAssociation)selection.getFirstElement();
                if (MergeFileAssociationPreferencePage.this.updating && mergeFileAssociation != null) {
                    MergeFileAssociationPreferencePage.this.associationsUpdated = true;
                    mergeFileAssociation.setMergeProgram(MergeFileAssociationPreferencePage.this.customProgramLocationCombo.getText().trim());
                    mergeFileAssociation.setParameters(MergeFileAssociationPreferencePage.this.customProgramParametersText.getText().trim());
                }
            }
        };
        this.customProgramLocationCombo.addModifyListener(modifyListener);
        this.customProgramParametersText.addModifyListener(modifyListener);
        FocusAdapter focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                ((Text)e.getSource()).setText(((Text)e.getSource()).getText());
            }
        };
        this.customProgramParametersText.addFocusListener((FocusListener)focusListener);
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    public boolean performOk() {
        MergeFileAssociation[] currentAssociations = this.getMergeFileAssociations();
        int i = 0;
        while (i < currentAssociations.length) {
            currentAssociations[i].remove();
            ++i;
        }
        i = 0;
        while (i < this.mergeFileAssociations.length) {
            Preferences prefs = MergeFileAssociation.getParentPreferences().node(this.mergeFileAssociations[i].getFileType());
            if (this.mergeFileAssociations[i].getMergeProgram() == null) {
                prefs.put("mergeProgram", "");
            } else {
                prefs.put("mergeProgram", this.mergeFileAssociations[i].getMergeProgram());
            }
            if (this.mergeFileAssociations[i].getParameters() == null) {
                prefs.put("parameters", "");
            } else {
                prefs.put("parameters", this.mergeFileAssociations[i].getParameters());
            }
            prefs.putInt("type", this.mergeFileAssociations[i].getType());
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
            ++i;
        }
        return super.performOk();
    }

    public boolean performCancel() {
        if (this.associationsUpdated && MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("MergeFileAssociationPreferencePage.title"), (String)Policy.bind("MergeFileAssociationPreferencePage.confirmCancel"))) {
            this.performOk();
        }
        return super.performCancel();
    }

    public void dispose() {
        for (Image image : images) {
            image.dispose();
        }
        super.dispose();
    }

    private void addFileType() {
        NewMergeFileAssociationWizard wizard = new NewMergeFileAssociationWizard(this.mergeFileAssociations);
        ClosableWizardDialog dialog = new ClosableWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        if (dialog.open() == 1) {
            return;
        }
        this.associationsUpdated = true;
        ArrayList<MergeFileAssociation> associationsList = new ArrayList<MergeFileAssociation>();
        int i = 0;
        while (i < this.mergeFileAssociations.length) {
            associationsList.add(this.mergeFileAssociations[i]);
            ++i;
        }
        associationsList.add(wizard.getMergeFileAssociation());
        this.mergeFileAssociations = new MergeFileAssociation[associationsList.size()];
        associationsList.toArray(this.mergeFileAssociations);
        Arrays.sort(this.mergeFileAssociations);
        this.viewer.refresh();
    }

    private void removeFileType() {
        this.associationsUpdated = true;
        ArrayList<MergeFileAssociation> associationsList = new ArrayList<MergeFileAssociation>();
        int i = 0;
        while (i < this.mergeFileAssociations.length) {
            associationsList.add(this.mergeFileAssociations[i]);
            ++i;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            associationsList.remove(iter.next());
        }
        this.mergeFileAssociations = new MergeFileAssociation[associationsList.size()];
        associationsList.toArray(this.mergeFileAssociations);
        this.viewer.refresh();
        this.builtInMergeRadioButton.setSelection(false);
        this.externalMergeRadioButton.setSelection(false);
        this.customMergeRadioButton.setSelection(false);
        this.customProgramLocationCombo.setText("");
        this.customProgramParametersText.setText("");
    }

    private MergeFileAssociation[] getMergeFileAssociations() {
        try {
            return SVNUIPlugin.getPlugin().getMergeFileAssociations();
        }
        catch (BackingStoreException e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
            return new MergeFileAssociation[0];
        }
    }

    private void addVariables(Text target, Map bindings) {
        final ArrayList<StringPair> variables = new ArrayList<StringPair>(bindings.size());
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((StringPair)element).s1) + " - " + ((StringPair)element).s2;
            }
        };
        IStructuredContentProvider contentsProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return variables.toArray(new StringPair[variables.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        Iterator it = bindings.keySet().iterator();
        while (it.hasNext()) {
            StringPair variable = new StringPair();
            variable.s1 = (String)it.next();
            variable.s2 = (String)bindings.get(variable.s1);
            variables.add(variable);
        }
        ListDialog dialog = new ListDialog(this.getShell());
        dialog.setContentProvider(contentsProvider);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setInput(variables);
        dialog.setTitle(Policy.bind("DiffMergePreferencePage.addVariableDialogTitle"));
        if (dialog.open() != 0) {
            return;
        }
        Object[] result = dialog.getResult();
        int i = 0;
        while (i < result.length) {
            target.insert("${" + ((StringPair)result[i]).s1 + "}");
            ++i;
        }
    }

    private Map getMergeBindingDescriptions() {
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("merged", Policy.bind("DiffMergePreferencePage.mergedVariableComment"));
        bindings.put("theirs", Policy.bind("DiffMergePreferencePage.theirsVariableComment"));
        bindings.put("yours", Policy.bind("DiffMergePreferencePage.yoursVariableComment"));
        bindings.put("base", Policy.bind("DiffMergePreferencePage.baseVariableComment"));
        return bindings;
    }

    class StringPair {
        String s1;
        String s2;

        StringPair() {
        }
    }

    class MergeFileAssociationsContentProvider
    implements IStructuredContentProvider {
        MergeFileAssociationsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object obj) {
            return MergeFileAssociationPreferencePage.this.mergeFileAssociations;
        }
    }

    static class MergeFileAssociationsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MergeFileAssociationsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            MergeFileAssociation mergeFileAssociation = (MergeFileAssociation)element;
            switch (columnIndex) {
                case 0: {
                    return mergeFileAssociation.getFileType();
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            MergeFileAssociation mergeFileAssociation = (MergeFileAssociation)element;
            ImageDescriptor id = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(mergeFileAssociation.getFileType());
            if (id == null) {
                id = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor("file.txt");
            }
            if (id != null) {
                Image image = id.createImage();
                images.add(image);
                return image;
            }
            return null;
        }
    }
}

