/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalResourceNode;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class ResourceEditionNode
implements IStructureComparator,
ITypedElement,
IStreamContentAccessor,
IEncodedStreamContentAccessor {
    private ISVNRemoteResource resource;
    private ResourceEditionNode[] children;
    private SVNLocalResourceNode localResource = null;
    private String charset = "UTF8";
    private SVNRevision pegRevision;
    private boolean ignoreHiddenChanges = SVNProviderPlugin.getPlugin().getPluginPreferences().getBoolean("ignore_hidden_changes");

    public ResourceEditionNode(ISVNRemoteResource resourceEdition) {
        this(resourceEdition, null);
    }

    public ResourceEditionNode(ISVNRemoteResource resourceEdition, SVNRevision pegRevision) {
        this.resource = resourceEdition;
        this.pegRevision = pegRevision;
        if (pegRevision == null) {
            pegRevision = SVNRevision.HEAD;
        }
        if (this.resource instanceof RemoteFolder) {
            ((RemoteFolder)this.resource).setPegRevision(pegRevision);
        } else if (this.resource instanceof RemoteFile) {
            ((RemoteFile)this.resource).setPegRevision(pegRevision);
        }
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.resource;
    }

    public boolean equals(Object other) {
        if (other instanceof ITypedElement) {
            String otherName = ((ITypedElement)other).getName();
            return this.getName().equals(otherName);
        }
        return super.equals(other);
    }

    public Object[] getChildren() {
        block9: {
            if (this.children == null) {
                this.children = new ResourceEditionNode[0];
                ISVNLocalResource mylocalResource = null;
                if (this.localResource instanceof SVNLocalResourceNode) {
                    mylocalResource = this.localResource.getLocalResource();
                    try {
                        if (!mylocalResource.isDirty() && mylocalResource.getResource().getProjectRelativePath().toString().equals(this.getRemoteResource().getProjectRelativePath()) && mylocalResource.getStatus().getLastChangedRevision().equals((Object)this.getRemoteResource().getLastChangedRevision())) {
                            return this.children;
                        }
                    }
                    catch (CoreException e) {
                        SVNUIPlugin.log(4, e.getMessage(), e);
                    }
                }
                if (this.resource != null) {
                    try {
                        SVNUIPlugin.runWithProgress(null, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                try {
                                    ISVNRemoteResource[] members = ResourceEditionNode.this.resource.members(monitor);
                                    ArrayList<ResourceEditionNode> nonHiddenChildren = new ArrayList<ResourceEditionNode>();
                                    int i = 0;
                                    while (i < members.length) {
                                        if (!ResourceEditionNode.this.ignoreHiddenChanges || members[i].getResource() == null || !Util.isHidden((IResource)members[i].getResource(), (boolean)false)) {
                                            ResourceEditionNode child = new ResourceEditionNode(members[i], ResourceEditionNode.this.pegRevision);
                                            SVNLocalResourceNode localNode = ResourceEditionNode.this.matchLocalResource(members[i]);
                                            if (localNode != null) {
                                                child.setLocalResource(localNode);
                                                localNode.setRemoteResource(child);
                                                try {
                                                    child.setCharset(localNode.getCharset());
                                                }
                                                catch (CoreException e) {
                                                    SVNUIPlugin.log(4, e.getMessage(), e);
                                                }
                                            }
                                            nonHiddenChildren.add(child);
                                        }
                                        ++i;
                                    }
                                    ResourceEditionNode.this.children = new ResourceEditionNode[nonHiddenChildren.size()];
                                    nonHiddenChildren.toArray(ResourceEditionNode.this.children);
                                }
                                catch (TeamException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getTargetException();
                        if (!(t instanceof TeamException)) break block9;
                        SVNUIPlugin.log(((TeamException)t).getStatus());
                    }
                }
            }
        }
        return this.children;
    }

    public InputStream getContents() throws CoreException {
        block4: {
            if (this.resource == null || this.resource.isContainer()) {
                return null;
            }
            try {
                final InputStream[] holder = new InputStream[1];
                SVNUIPlugin.runWithProgress(null, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            holder[0] = ResourceEditionNode.this.resource.getStorage(monitor).getContents();
                        }
                        catch (CoreException e1) {
                            SVNUIPlugin.log(e1);
                        }
                    }
                });
                return holder[0];
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof TeamException)) break block4;
                throw new CoreException(((TeamException)t).getStatus());
            }
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public Image getImage() {
        return CompareUI.getImage((IAdaptable)this.resource);
    }

    public String getName() {
        return this.resource == null ? "" : this.resource.getName();
    }

    public String getType() {
        if (this.resource == null) {
            return "???";
        }
        if (this.resource.isContainer()) {
            return "FOLDER";
        }
        String name = this.resource.getName();
        return (name = name.substring(name.lastIndexOf(46) + 1)).length() == 0 ? "???" : name;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getCharset() throws CoreException {
        return this.charset;
    }

    public void setCharset(String charset) throws CoreException {
        this.charset = charset;
    }

    public void setLocalResource(SVNLocalResourceNode localResource) {
        this.localResource = localResource;
    }

    private SVNLocalResourceNode matchLocalResource(ISVNRemoteResource remoteNode) {
        if (this.localResource == null) {
            return null;
        }
        ISVNRemoteResource baseFolder = remoteNode;
        if (baseFolder.getParent() != null) {
            baseFolder = baseFolder.getParent();
        }
        Object[] lrn = this.localResource.getChildren();
        String remotePath = remoteNode.getRepositoryRelativePath();
        remotePath = remotePath.replaceAll(baseFolder.getRepositoryRelativePath(), "");
        int i = 0;
        while (i < lrn.length) {
            String localPath = ((SVNLocalResourceNode)((Object)lrn[i])).getResource().getFullPath().toString();
            if ((localPath = localPath.substring(this.localResource.getResource().getFullPath().toString().length())).equals(remotePath)) {
                return (SVNLocalResourceNode)((Object)lrn[i]);
            }
            ++i;
        }
        return null;
    }
}

