/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template.infrastructure.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.ide.eclipse.wizard.template.SpringVersion;
import org.springframework.ide.eclipse.wizard.template.SpringVersionProcessor;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.FileUtil;

public class TemplateProcessor {
    private static Logger logger = Logger.getLogger(TemplateProcessor.class);
    protected Map<String, String> replacementContext = new HashMap<String, String>();
    protected SpringVersionProcessor springProcessor;

    public TemplateProcessor(Map<String, String> replacementContext) {
        this.replacementContext = replacementContext;
    }

    public TemplateProcessor(Map<String, String> replacementContext, SpringVersion springVersion) {
        this.replacementContext = replacementContext;
        if (springVersion != null && !springVersion.equals(SpringVersion.DEFAULT)) {
            this.springProcessor = new SpringVersionProcessor(springVersion.getVersion());
        }
    }

    public void process(File source, File target) throws IOException {
        if (FileUtil.isBinaryFile(source)) {
            logger.debug((Object)("Copying binary file " + source));
            FileUtil.copy(source, target);
        } else {
            logger.debug((Object)("Template processing text file " + source));
            this.process(new FileReader(source), new FileWriter(target));
        }
    }

    public void process(Reader reader, Writer writer) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        while ((line = bufferedReader.readLine()) != null) {
            line = this.replaceTokens(line);
            bufferedWriter.write(line);
            bufferedWriter.write(10);
        }
        bufferedWriter.flush();
    }

    public String replaceTokens(String input) {
        String topLevelPackageStr = this.replacementContext.get("||top-level-package||");
        if (topLevelPackageStr != null) {
            if (topLevelPackageStr.startsWith("&&")) {
                topLevelPackageStr = topLevelPackageStr.substring(2);
            }
            topLevelPackageStr = topLevelPackageStr.replaceAll("&&", ".");
            String userTopLevelPackageStr = this.replacementContext.get("||user-top-level-package||");
            if (userTopLevelPackageStr.startsWith("&&")) {
                userTopLevelPackageStr = userTopLevelPackageStr.substring(2);
            }
            if (input.contains(topLevelPackageStr) && userTopLevelPackageStr != null) {
                int index = input.indexOf(topLevelPackageStr);
                String newInput = String.valueOf(input.substring(0, index)) + userTopLevelPackageStr.replaceAll("&&", ".");
                if (index + topLevelPackageStr.length() < input.length()) {
                    newInput = String.valueOf(newInput) + input.substring(index + topLevelPackageStr.length());
                }
                input = newInput;
            }
        }
        for (String token : this.replacementContext.keySet()) {
            String replacement = this.replacementContext.get(token);
            input = input.replace(token, replacement);
        }
        if (input.indexOf("my") >= 0) {
            logger.warn((Object)("May have failed to replace token " + input));
        }
        return input;
    }

    public String replacePathForDirectory(String path, char separator) {
        String originalTopLevelPackageStr = this.replacementContext.get("||top-level-package||");
        if (originalTopLevelPackageStr != null) {
            originalTopLevelPackageStr = originalTopLevelPackageStr.replaceAll("&&", "\\" + separator);
            String userTopLevelPackageStr = this.replacementContext.get("||user-top-level-package||");
            if (path.contains(originalTopLevelPackageStr) && userTopLevelPackageStr != null) {
                int index = path.indexOf(originalTopLevelPackageStr);
                String replacementString = userTopLevelPackageStr.replaceAll("&&", "\\" + separator);
                String newPath = String.valueOf(path.substring(0, index)) + replacementString;
                if (index + 1 + originalTopLevelPackageStr.length() < path.length()) {
                    newPath = String.valueOf(newPath) + path.substring(index + originalTopLevelPackageStr.length());
                }
                return newPath;
            }
        }
        return null;
    }
}

