/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ui.WizardUIInfoElement;

public class TemplateInputCollector {
    private final Map<String, Object> collectedInput;
    private final Map<String, String> inputKinds;
    private final List<WizardUIInfoElement> elements;

    public TemplateInputCollector(List<WizardUIInfoElement> elements) {
        this.elements = elements;
        this.collectedInput = new HashMap<String, Object>();
        this.inputKinds = new HashMap<String, String>();
        this.initInputElements();
    }

    protected void initInputElements() {
        for (WizardUIInfoElement element : this.elements) {
            String elementName = element.getName();
            this.collectedInput.put(elementName, null);
            String replaceKind = element.getReplaceKind();
            if (replaceKind != null) {
                this.inputKinds.put(elementName, replaceKind);
                continue;
            }
            this.inputKinds.put(elementName, "token");
        }
    }

    public boolean updateInput(String elementName, Object value) {
        if (this.collectedInput.containsKey(elementName)) {
            this.collectedInput.put(elementName, value);
            return true;
        }
        return false;
    }

    public List<WizardUIInfoElement> getInfoElements() {
        return this.elements;
    }

    public Map<String, Object> getCollectedInput() {
        return this.collectedInput;
    }

    public Map<String, String> getInputKinds() {
        return this.inputKinds;
    }
}

