/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

public class SpringVersionProcessor {
    public static final String MAVEN_SPRING_ELEMENT_START_TAG = "<org.springframework-version>";
    public static final String MAVEN_SPRING_ELEMENT_END_TAG = "</org.springframework-version>";
    public final String springVersion;
    private boolean isReplacing = false;

    public SpringVersionProcessor(String springVersion) {
        this.springVersion = springVersion;
    }

    public boolean isReplacing(String line) {
        if (!this.isReplacing) {
            this.isReplacing = line != null && line.contains(MAVEN_SPRING_ELEMENT_START_TAG);
        }
        return this.isReplacing;
    }

    public String replace(String line) {
        if (line == null || !this.isReplacing) {
            return null;
        }
        String replacedLine = "";
        if (line.contains(MAVEN_SPRING_ELEMENT_START_TAG)) {
            if (line.contains(MAVEN_SPRING_ELEMENT_END_TAG)) {
                this.isReplacing = false;
            }
            replacedLine = MAVEN_SPRING_ELEMENT_START_TAG + this.springVersion + MAVEN_SPRING_ELEMENT_END_TAG;
        } else if (line.contains(MAVEN_SPRING_ELEMENT_END_TAG)) {
            this.isReplacing = false;
        }
        return replacedLine;
    }
}

