/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;

public class ExceptionUtil {
    public static final IStatus OK_STATUS = ExceptionUtil.status(0, "");

    public static CoreException coreException(int severity, String msg) {
        return ExceptionUtil.coreException(ExceptionUtil.status(severity, msg));
    }

    public static CoreException coreException(IStatus status) {
        Throwable e = status.getException();
        if (e == null) {
            return new CoreException(status);
        }
        if (e instanceof CoreException) {
            return (CoreException)e;
        }
        return new CoreException(status);
    }

    public static CoreException coreException(String msg) {
        return ExceptionUtil.coreException(4, msg);
    }

    public static CoreException coreException(Throwable e) {
        if (e instanceof CoreException) {
            return (CoreException)e;
        }
        return ExceptionUtil.coreException(ExceptionUtil.status(e));
    }

    public static Throwable getDeepestCause(Throwable e) {
        Throwable cause = e;
        Throwable parent = e.getCause();
        while (parent != null && parent != e) {
            cause = parent;
            parent = cause.getCause();
        }
        return cause;
    }

    public static String getMessage(Throwable e) {
        Throwable cause = ExceptionUtil.getDeepestCause(e);
        String msg = String.valueOf(cause.getClass().getSimpleName()) + ": " + cause.getMessage();
        return msg;
    }

    public static IllegalStateException notImplemented(String string) {
        return new IllegalStateException("Not implemented: " + string);
    }

    public static IStatus status(int severity, String msg) {
        return new Status(severity, "org.springsource.ide.eclipse.commons.frameworks.core", msg);
    }

    public static IStatus status(Throwable e) {
        return ExceptionUtil.status(4, e);
    }

    public static IStatus status(int severity, Throwable e) {
        Throwable ee;
        IStatus status;
        if (e instanceof OperationCanceledException || e instanceof InterruptedException) {
            return Status.CANCEL_STATUS;
        }
        if (e instanceof CoreException && (status = ((CoreException)e).getStatus()) != null && status.getSeverity() == severity && (ee = status.getException()) != null) {
            return status;
        }
        return new Status(severity, "org.springsource.ide.eclipse.commons.frameworks.core", ExceptionUtil.getMessage(e), e);
    }

    public static IStatus status(String msg) {
        return ExceptionUtil.status(4, msg);
    }

    public static Exception exception(Throwable e) {
        if (e instanceof Exception) {
            return (Exception)e;
        }
        return ExceptionUtil.coreException(e);
    }

    public static RuntimeException unchecked(Exception e) {
        return new RuntimeException(e);
    }

    public static String stacktrace() {
        return ExceptionUtil.stacktrace(new Exception("Stacktrace"));
    }

    public static String stacktrace(Exception exception) {
        ByteArrayOutputStream dump = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(dump);
        try {
            exception.printStackTrace(out);
        }
        finally {
            out.close();
        }
        return dump.toString();
    }
}

