/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.core.net;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;
import org.springsource.ide.eclipse.commons.internal.core.net.ITransportService;

public class P2TransportService
implements ITransportService {
    private Object transport;
    private Method downloadMethod;
    private Method streamMethod;
    private Method getLastModifiedMethod;

    public P2TransportService() throws ClassNotFoundException {
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.internal.p2.repository.RepositoryTransport");
                Method getInstanceMethod = clazz.getDeclaredMethod("getInstance", new Class[0]);
                this.transport = getInstanceMethod.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.transport = P2TransportService.getTransport_e3_7();
                clazz = this.transport.getClass();
            }
            this.downloadMethod = clazz.getDeclaredMethod("download", URI.class, OutputStream.class, IProgressMonitor.class);
            this.streamMethod = clazz.getDeclaredMethod("stream", URI.class, IProgressMonitor.class);
            this.getLastModifiedMethod = clazz.getDeclaredMethod("getLastModified", URI.class, IProgressMonitor.class);
        }
        catch (LinkageError e) {
            throw new ClassNotFoundException("Failed to load P2 transport", e);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Failed to load P2 transport", e);
        }
    }

    private static Object getTransport_e3_7() throws Exception {
        Class.forName("org.eclipse.equinox.p2.core.IProvisioningAgent");
        BundleContext bundleContext = CorePlugin.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference("org.eclipse.equinox.p2.core.IProvisioningAgent");
        if (serviceReference != null) {
            try {
                Object agent = bundleContext.getService(serviceReference);
                if (agent != null) {
                    Method getServiceMethod = agent.getClass().getDeclaredMethod("getService", String.class);
                    Object object = getServiceMethod.invoke(agent, "org.eclipse.equinox.internal.p2.repository.Transport");
                    return object;
                }
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
        throw new RuntimeException("Transport service not available");
    }

    private void convertException(InvocationTargetException e) throws CoreException {
        if (e.getCause() instanceof CoreException) {
            throw (CoreException)e.getCause();
        }
        throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", e.getCause().getMessage(), e.getCause()));
    }

    @Override
    public void download(URI uri, OutputStream out, IProgressMonitor monitor) throws CoreException {
        try {
            IStatus result = (IStatus)this.downloadMethod.invoke(this.transport, uri, out, monitor);
            if (result.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            if (!result.isOK()) {
                throw new CoreException(result);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getLastModified(URI location, IProgressMonitor monitor) throws CoreException {
        try {
            return (Long)this.getLastModifiedMethod.invoke(this.transport, location, monitor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.convertException(e);
            throw new IllegalStateException();
        }
    }

    @Override
    public InputStream stream(URI uri, IProgressMonitor monitor) throws CoreException {
        try {
            return (InputStream)this.streamMethod.invoke(this.transport, uri, monitor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            this.convertException(e);
            throw new IllegalStateException();
        }
    }
}

